/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.core.onefile.file;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.papyrus.infra.onefile.model.IPapyrusFile;
import org.eclipse.papyrus.infra.onefile.utils.OneFileUtils;
import org.eclipse.papyrus.model2doc.core.onefile.Activator;

public abstract class GeneratedDocumentFile
implements IPapyrusFile {
    private final IFile file;

    public GeneratedDocumentFile(IFile file) {
        this.file = file;
    }

    public String getText() {
        return this.getName().substring(0, this.getName().lastIndexOf(46));
    }

    public IProject getProject() {
        return this.file.getProject();
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public IResource[] getAssociatedResources() {
        ArrayList<IResource> files = new ArrayList<IResource>();
        try {
            IResource[] iResourceArray = this.file.getParent().members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource res = iResourceArray[n2];
                if (res instanceof IFile) {
                    String resourceWithoutExtension = OneFileUtils.withoutFileExtension((IResource)res);
                    String fileWithoutExtension = OneFileUtils.withoutFileExtension((IResource)this.file);
                    if (fileWithoutExtension.equals(resourceWithoutExtension)) {
                        files.add(res);
                    } else if ("properties".equals(res.getFileExtension()) && resourceWithoutExtension.startsWith(fileWithoutExtension)) {
                        String possibleLocale = resourceWithoutExtension.substring(fileWithoutExtension.length());
                        if (possibleLocale.startsWith("_")) {
                            possibleLocale = possibleLocale.substring(1);
                            Locale localeFound = null;
                            Iterator<Locale> availableLocales = Arrays.asList(Locale.getAvailableLocales()).iterator();
                            while (availableLocales.hasNext() && localeFound == null) {
                                Locale currentAvailableLocale = availableLocales.next();
                                if (!currentAvailableLocale.toString().equals(possibleLocale)) continue;
                                localeFound = currentAvailableLocale;
                            }
                            if (localeFound != null) {
                                files.add(res);
                            }
                        }
                    } else if (resourceWithoutExtension.startsWith(fileWithoutExtension) && this.isExtensionOfGeneratedDocument(res.getFileExtension())) {
                        files.add(res);
                    }
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            Activator.log.error("The file members cannot be found", (Throwable)e);
        }
        return files.toArray(new IResource[0]);
    }

    public IFile getMainFile() {
        return this.file;
    }

    public IContainer getParent() {
        return this.file.getParent();
    }

    public String getName() {
        return this.file.getName();
    }

    public int hashCode() {
        return this.getMainFile().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof GeneratedDocumentFile) {
            GeneratedDocumentFile papyrusDocumentFile = (GeneratedDocumentFile)obj;
            return this.getMainFile().equals((Object)papyrusDocumentFile.getMainFile());
        }
        return super.equals(obj);
    }

    protected abstract boolean isExtensionOfGeneratedDocument(String var1);
}

