/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.java.jdt.project;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.ui.actions.OpenNewJavaProjectWizardAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.m2e.core.ui.internal.wizards.MavenProjectWizard;
import org.eclipse.papyrus.designer.languages.common.extensionpoints.AbstractSettings;
import org.eclipse.papyrus.designer.languages.common.extensionpoints.ILangProjectSupport;
import org.eclipse.papyrus.designer.languages.common.profile.Codegen.MavenProject;
import org.eclipse.papyrus.designer.languages.java.jdt.project.CustomizePOMFile;
import org.eclipse.papyrus.designer.languages.java.jdt.project.JavaNamedProjectWizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.util.UMLUtil;

public class JavaProjectSupport
implements ILangProjectSupport {
    private int dialogStatus;
    private MavenProject mavenProjectDetails;

    public IProject createProject(String projectName) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(projectName);
        this.dialogStatus = 0;
        try {
            final JavaNamedProjectWizard wiz = new JavaNamedProjectWizard(projectName);
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    OpenNewJavaProjectWizardAction wizDiag = new OpenNewJavaProjectWizardAction();
                    wizDiag.setConfiguredWizardPages(wiz, null);
                    wizDiag.run();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            project = null;
        }
        if (this.dialogStatus == 1) {
            return null;
        }
        if (project == null || !project.exists()) {
            throw new RuntimeException("Could not create JDT project. This might indicate that there is a problem with your JDT installation.");
        }
        return project;
    }

    public IProject createProject(String projectName, Package modelRoot) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(projectName);
        this.mavenProjectDetails = (MavenProject)UMLUtil.getStereotypeApplication((Element)modelRoot, MavenProject.class);
        try {
            if (this.mavenProjectDetails == null) {
                final JavaNamedProjectWizard wiz = new JavaNamedProjectWizard(projectName);
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        OpenNewJavaProjectWizardAction wizDiag = new OpenNewJavaProjectWizardAction();
                        wizDiag.setConfiguredWizardPages(wiz, null);
                        wizDiag.run();
                    }
                });
            } else {
                final MavenProjectWizard mavenWiz = new MavenProjectWizard();
                mavenWiz.setWindowTitle(projectName);
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        IWorkbench wb = PlatformUI.getWorkbench();
                        mavenWiz.init(wb, (IStructuredSelection)new StructuredSelection());
                        Shell shell = wb.getActiveWorkbenchWindow().getShell();
                        WizardDialog dialog = new WizardDialog(shell, (IWizard)mavenWiz);
                        dialog.create();
                        dialog.open();
                    }
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        project = root.getProject(projectName);
        return project;
    }

    public void setSettings(IProject project, AbstractSettings settings) {
        if (project != null && this.mavenProjectDetails != null) {
            CustomizePOMFile customizePOMFile = new CustomizePOMFile(project, this.mavenProjectDetails);
            customizePOMFile.execute();
        }
    }

    public AbstractSettings initialConfigurationData() {
        return null;
    }

    public void gatherConfigData(Classifier implementation, AbstractSettings settings) {
    }
}

