/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.query.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.modisco.infra.common.core.internal.builder.AbstractMoDiscoCatalog;
import org.eclipse.modisco.infra.common.core.internal.builder.EcoreCatalog;
import org.eclipse.modisco.infra.query.ModelQuery;
import org.eclipse.modisco.infra.query.ModelQuerySet;
import org.eclipse.modisco.infra.query.QueryPackage;
import org.eclipse.modisco.infra.query.core.AbstractModelQuery;
import org.eclipse.modisco.infra.query.core.IModelQueryFactory;
import org.eclipse.modisco.infra.query.core.exception.ModelQueryException;
import org.eclipse.modisco.infra.query.core.internal.Activator;
import org.eclipse.modisco.infra.query.core.internal.validation.EValidatorAdapter;
import org.osgi.framework.Bundle;

@Deprecated
public final class ModelQuerySetCatalog
extends AbstractMoDiscoCatalog {
    public static final String REGISTRATION_EXTENSION_POINT_ID = "org.eclipse.modisco.infra.query.registration";
    public static final String FACTORY_EXTENSION_POINT_ID = "org.eclipse.modisco.infra.query.factory";
    public static final String FILE_EXTENSION = "querySet";
    private static ModelQuerySetCatalog singleton = null;
    private final List<IModelQueryFactory> installedModelQueryFactory = new ArrayList<IModelQueryFactory>();

    public static synchronized ModelQuerySetCatalog getSingleton() {
        if (singleton == null) {
            EValidator validator = EValidator.Registry.INSTANCE.getEValidator((EPackage)QueryPackage.eINSTANCE);
            if (validator == null) {
                EValidator.Registry.INSTANCE.put((Object)QueryPackage.eINSTANCE, (Object)new EValidatorAdapter());
            }
            EcoreCatalog.getSingleton();
            singleton = new ModelQuerySetCatalog();
        }
        return singleton;
    }

    private ModelQuerySetCatalog() {
        this.initInstalledModelQueryFactory();
    }

    protected String getRootObjectName(EObject rootObject) {
        return ((ModelQuerySet)rootObject).getName();
    }

    protected String getRootObjectNsUri(EObject rootObject) {
        return "modisco:/query/" + ((ModelQuerySet)rootObject).getName();
    }

    protected Class<?> getRootClass() {
        return ModelQuerySet.class;
    }

    public ModelQuerySet getModelQuerySet(String name) {
        return (ModelQuerySet)this.getRootObject(name);
    }

    protected String getRegistryExtensionPoint() {
        return REGISTRATION_EXTENSION_POINT_ID;
    }

    public Collection<ModelQuerySet> getAllModelQuerySets() {
        ArrayList<ModelQuerySet> result = new ArrayList<ModelQuerySet>();
        for (EObject eObject : this.getAllRootObjects()) {
            if (!(eObject instanceof ModelQuerySet)) continue;
            ModelQuerySet querySet = (ModelQuerySet)eObject;
            result.add(querySet);
        }
        return result;
    }

    private synchronized void initInstalledModelQueryFactory() {
        IConfigurationElement[] configs;
        IConfigurationElement[] iConfigurationElementArray = configs = Platform.getExtensionRegistry().getConfigurationElementsFor(FACTORY_EXTENSION_POINT_ID);
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            block6: {
                IConfigurationElement config = iConfigurationElementArray[n2];
                if ("factory".equals(config.getName())) {
                    String className = config.getAttribute("class");
                    Bundle bundle = Platform.getBundle((String)config.getNamespaceIdentifier());
                    Class modelQueryFactoryClass = null;
                    try {
                        Class<?> interfaces;
                        Class aClass = bundle.loadClass(className);
                        Class<?>[] classArray = aClass.getInterfaces();
                        if (classArray.length != 0 && (interfaces = classArray[0]) == IModelQueryFactory.class) {
                            modelQueryFactoryClass = aClass;
                        }
                        if (modelQueryFactoryClass != null) {
                            this.installedModelQueryFactory.add((IModelQueryFactory)modelQueryFactoryClass.newInstance());
                            break block6;
                        }
                        throw new Exception("aClass does not implements IModelQueryFactory.");
                    }
                    catch (Exception e) {
                        Status status = new Status(4, "org.eclipse.modisco.infra.query.core", "Failed to load IJavaModelFactory for: " + config.getNamespaceIdentifier(), (Throwable)e);
                        Activator.getDefault().getLog().log((IStatus)status);
                    }
                }
            }
            ++n2;
        }
    }

    public List<IModelQueryFactory> getInstalledModelQueryFactory() {
        return this.installedModelQueryFactory;
    }

    public synchronized AbstractModelQuery getModelQueryImpl(ModelQuery modelQuery) throws ModelQueryException {
        AbstractModelQuery modelQueryInst = null;
        boolean factoryFound = false;
        for (IModelQueryFactory modelQueryFactory : this.installedModelQueryFactory) {
            factoryFound = modelQueryFactory.getManagedModelQueryType().getName().equals(modelQuery.eClass().getName());
            if (!factoryFound) continue;
            modelQueryInst = modelQueryFactory.create(modelQuery, this.getBundle((EObject)modelQuery.getModelQuerySet()));
            break;
        }
        if (!factoryFound) {
            StringBuffer sb = new StringBuffer();
            sb.append("No factory implementation found for: ");
            sb.append(modelQuery.eClass().getName());
            sb.append(":");
            sb.append(modelQuery.getName());
            sb.append("\n Available ModelQuery types are: ");
            for (IModelQueryFactory modelQueryFactory : this.installedModelQueryFactory) {
                sb.append(modelQueryFactory.getManagedModelQueryType().getName());
                sb.append(", ");
            }
            ModelQueryException e = new ModelQueryException(sb.toString());
            throw e;
        }
        return modelQueryInst;
    }

    protected String getMoDiscoSubProtocol() {
        return "query";
    }

    protected Plugin getActivator() {
        return Activator.getDefault();
    }

    public String getFileExtension() {
        return FILE_EXTENSION;
    }

    protected void preRemove(IFile declarationFile, String pathName, EObject oldRootObject) {
    }

    protected void postOpenResource(URI uri, IFile file, EObject root) {
    }
}

