/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.force;

import java.util.ArrayList;
import java.util.Iterator;
import prefuse.util.force.Force;
import prefuse.util.force.ForceItem;
import prefuse.util.force.Integrator;
import prefuse.util.force.RungeKuttaIntegrator;
import prefuse.util.force.Spring;

public class ForceSimulator {
    private ArrayList items;
    private ArrayList springs;
    private Force[] iforces;
    private Force[] sforces;
    private int iflen;
    private int sflen;
    private Integrator integrator;
    private float speedLimit = 1.0f;

    public ForceSimulator() {
        this(new RungeKuttaIntegrator());
    }

    public ForceSimulator(Integrator integr) {
        this.integrator = integr;
        this.iforces = new Force[5];
        this.sforces = new Force[5];
        this.iflen = 0;
        this.sflen = 0;
        this.items = new ArrayList();
        this.springs = new ArrayList();
    }

    public float getSpeedLimit() {
        return this.speedLimit;
    }

    public void setSpeedLimit(float limit) {
        this.speedLimit = limit;
    }

    public Integrator getIntegrator() {
        return this.integrator;
    }

    public void setIntegrator(Integrator intgr) {
        this.integrator = intgr;
    }

    public void clear() {
        this.items.clear();
        Iterator siter = this.springs.iterator();
        Spring.SpringFactory f = Spring.getFactory();
        while (siter.hasNext()) {
            f.reclaim((Spring)siter.next());
        }
        this.springs.clear();
    }

    public void addForce(Force f) {
        Force[] newf;
        if (f.isItemForce()) {
            if (this.iforces.length == this.iflen) {
                newf = new Force[this.iflen + 10];
                System.arraycopy(this.iforces, 0, newf, 0, this.iforces.length);
                this.iforces = newf;
            }
            this.iforces[this.iflen++] = f;
        }
        if (f.isSpringForce()) {
            if (this.sforces.length == this.sflen) {
                newf = new Force[this.sflen + 10];
                System.arraycopy(this.sforces, 0, newf, 0, this.sforces.length);
                this.sforces = newf;
            }
            this.sforces[this.sflen++] = f;
        }
    }

    public Force[] getForces() {
        Force[] rv = new Force[this.iflen + this.sflen];
        System.arraycopy(this.iforces, 0, rv, 0, this.iflen);
        System.arraycopy(this.sforces, 0, rv, this.iflen, this.sflen);
        return rv;
    }

    public void addItem(ForceItem item) {
        this.items.add(item);
    }

    public boolean removeItem(ForceItem item) {
        return this.items.remove(item);
    }

    public Iterator getItems() {
        return this.items.iterator();
    }

    public Spring addSpring(ForceItem item1, ForceItem item2) {
        return this.addSpring(item1, item2, -1.0f, -1.0f);
    }

    public Spring addSpring(ForceItem item1, ForceItem item2, float length) {
        return this.addSpring(item1, item2, -1.0f, length);
    }

    public Spring addSpring(ForceItem item1, ForceItem item2, float coeff, float length) {
        if (item1 == null || item2 == null) {
            throw new IllegalArgumentException("ForceItems must be non-null");
        }
        Spring s = Spring.getFactory().getSpring(item1, item2, coeff, length);
        this.springs.add(s);
        return s;
    }

    public Iterator getSprings() {
        return this.springs.iterator();
    }

    public void runSimulator(long timestep) {
        this.accumulate();
        this.integrator.integrate(this, timestep);
    }

    public void accumulate() {
        int i = 0;
        while (i < this.iflen) {
            this.iforces[i].init(this);
            ++i;
        }
        i = 0;
        while (i < this.sflen) {
            this.sforces[i].init(this);
            ++i;
        }
        for (ForceItem item : this.items) {
            item.force[0] = 0.0f;
            item.force[1] = 0.0f;
            int i2 = 0;
            while (i2 < this.iflen) {
                this.iforces[i2].getForce(item);
                ++i2;
            }
        }
        for (Spring s : this.springs) {
            int i3 = 0;
            while (i3 < this.sflen) {
                this.sforces[i3].getForce(s);
                ++i3;
            }
        }
    }
}

