/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.xpand2.pr.util;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericFileFilter
implements FilenameFilter {
    private final Log log = LogFactory.getLog(this.getClass());
    public static final String DEFAULTIGNORELIST = "RCS     SCCS    CVS     CVS.adm RCSLOG  cvslog.* tags    TAGS .make.state     .nse_depinfo *~      #*      .#*     ,*      _$*     *$ *.old   *.bak   *.BAK   *.orig  *.rej   .del-* *.a     *.olb   *.o     *.obj   *.so    *.exe *.Z     *.elc   *.ln core .svn";
    private String ivIgnoreList;
    private List<GlobbingFileFilter> fileFilters = null;

    public GenericFileFilter(String aIgnoreList, boolean aDefaultexcludes) {
        String string = this.ivIgnoreList = aDefaultexcludes ? DEFAULTIGNORELIST : "";
        if (aIgnoreList != null) {
            this.ivIgnoreList = String.valueOf(this.ivIgnoreList) + aIgnoreList;
        }
        this.fileFilters = this.buildFileFilters(this.ivIgnoreList);
    }

    public GenericFileFilter(String aIgnoreList) {
        this(aIgnoreList, false);
    }

    public GenericFileFilter() {
        this(null);
    }

    @Override
    public boolean accept(File dir, String name) {
        return this.accept(new File(dir, name));
    }

    public boolean accept(File file) {
        if (!file.isFile() && !file.isDirectory()) {
            return false;
        }
        for (FileFilter fileFilter : this.fileFilters) {
            if (!fileFilter.accept(file)) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("File " + file + " excluded (pattern: " + fileFilter + ")."));
            }
            return false;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("File " + file + " included."));
        }
        return true;
    }

    private List<GlobbingFileFilter> buildFileFilters(String aIgnoreList) {
        ArrayList<GlobbingFileFilter> fileFilters = new ArrayList<GlobbingFileFilter>();
        StringTokenizer st = new StringTokenizer(aIgnoreList);
        while (st.hasMoreTokens()) {
            String pattern = st.nextToken();
            fileFilters.add(new GlobbingFileFilter(pattern));
        }
        return fileFilters;
    }

    public String toString() {
        return this.ivIgnoreList;
    }

    private static class GlobbingFileFilter
    implements FileFilter {
        private String globvalue;

        public GlobbingFileFilter(String globvalue) {
            this.globvalue = globvalue;
        }

        public boolean accept(File pathname) {
            int pos = this.globvalue.indexOf("*");
            if (pos == -1) {
                return pathname.getName().equals(this.globvalue);
            }
            if (pos != this.globvalue.lastIndexOf("*")) {
                throw new IllegalArgumentException("GlobbingFileFilter does not support multiple stars (" + this.globvalue + ").");
            }
            if (pos == 0) {
                return pathname.getName().endsWith(this.globvalue.substring(pos + 1));
            }
            if (pos == this.globvalue.length() - 1) {
                return pathname.getName().startsWith(this.globvalue.substring(0, pos));
            }
            throw new IllegalArgumentException("GlobbingFileFilter does not support stars in the middle (" + this.globvalue + ").");
        }

        public String toString() {
            return this.globvalue;
        }
    }
}

