/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpand.ui.editor;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.xpand.ui.editor.codeassist.XpandContentAssistProcessor;
import org.eclipse.xpand.ui.editor.scanning.CommentScanner;
import org.eclipse.xpand.ui.editor.scanning.ContentScanner;
import org.eclipse.xpand.ui.editor.scanning.TemplateTagScanner;
import org.eclipse.xtend.shared.ui.core.builder.XtendXpandProblemHover;
import org.eclipse.xtend.shared.ui.editor.AbstractXtendXandSourceViewerConfiguration;

public class XpandSourceViewerConfiguration
extends AbstractXtendXandSourceViewerConfiguration {
    private ContentScanner contentScanner;
    private CommentScanner commentScanner;
    private TemplateTagScanner tagScanner;

    public XpandSourceViewerConfiguration(IEditorPart editor, IPreferenceStore preferenceStore) {
        super(editor, preferenceStore);
    }

    public String[] getConfiguredContentTypes(ISourceViewer aSourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__tag", "__comment"};
    }

    public void createContentAssistProcessor(ContentAssistant contentAssistant) {
        XpandContentAssistProcessor processor = new XpandContentAssistProcessor(this.getEditor());
        contentAssistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__dftl_partition_content_type");
        contentAssistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__tag");
        contentAssistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__comment");
    }

    public String[] getIndentPrefixes(ISourceViewer aSourceViewer, String aContentType) {
        return new String[]{"\t", "    "};
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer aSourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer(this.getTemplateTagScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__tag");
        reconciler.setRepairer((IPresentationRepairer)dr, "__tag");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getCommentScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__comment");
        reconciler.setRepairer((IPresentationRepairer)dr, "__comment");
        dr = new DefaultDamagerRepairer(this.getContentScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        return reconciler;
    }

    private CommentScanner getCommentScanner() {
        if (this.commentScanner == null) {
            this.commentScanner = new CommentScanner();
        }
        return this.commentScanner;
    }

    protected ITokenScanner getTemplateTagScanner() {
        if (this.tagScanner == null) {
            this.tagScanner = new TemplateTagScanner();
        }
        return this.tagScanner;
    }

    protected ITokenScanner getContentScanner() {
        if (this.contentScanner == null) {
            this.contentScanner = new ContentScanner();
        }
        return this.contentScanner;
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return new XtendXpandProblemHover(sourceViewer);
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        return new XtendXpandProblemHover(sourceViewer);
    }
}

