/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.taglib.control;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class IteratingTagStatus {
    private final long begin;
    private final long count;
    private final long end;
    private long index;
    private Element status;

    public IteratingTagStatus(long begin, long count) {
        this.begin = begin;
        this.count = count;
        this.end = begin + count - 1L;
        this.index = begin;
    }

    public IteratingTagStatus(int count) {
        this(0L, count);
    }

    public final long getIndex() {
        return this.index;
    }

    public final void next() {
        ++this.index;
    }

    public final long getBegin() {
        return this.begin;
    }

    public final long getCount() {
        return this.count;
    }

    public final long getEnd() {
        return this.end;
    }

    public final boolean isFirst() {
        return this.index == this.begin;
    }

    public final boolean isLast() {
        return this.index == this.end;
    }

    public Object getStatusObject() {
        if (this.status == null) {
            Document document = this.createDocument();
            this.status = document.createElement("status");
        }
        this.status.setAttribute("begin", Long.toString(this.begin));
        this.status.setAttribute("end", Long.toString(this.end));
        this.status.setAttribute("index", Long.toString(this.index));
        this.status.setAttribute("count", Long.toString(this.count));
        if (this.isFirst()) {
            this.status.setAttribute("isFirst", "true");
        } else {
            this.status.removeAttribute("isFirst");
        }
        if (this.isLast()) {
            this.status.setAttribute("isLast", "true");
        } else {
            this.status.removeAttribute("isLast");
        }
        return this.status;
    }

    private Document createDocument() {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (FactoryConfigurationError e) {
            throw new RuntimeException(e);
        }
    }
}

