/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.views.result;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.acceleo.engine.event.AcceleoTextGenerationEvent;
import org.eclipse.acceleo.engine.event.IAcceleoTextGenerationListener;
import org.eclipse.acceleo.internal.ide.ui.views.result.TraceabilityContainer;
import org.eclipse.acceleo.internal.ide.ui.views.result.TraceabilityModel;
import org.eclipse.acceleo.internal.ide.ui.views.result.TraceabilityRegion;
import org.eclipse.acceleo.internal.ide.ui.views.result.TraceabilityTargetFile;
import org.eclipse.acceleo.internal.ide.ui.views.result.TraceabilityTemplate;
import org.eclipse.acceleo.model.mtl.Block;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.acceleo.model.mtl.ModuleElement;
import org.eclipse.acceleo.model.mtl.TemplateExpression;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class AcceleoResultContent
implements IAcceleoTextGenerationListener {
    private Map<String, TraceabilityTargetFile> targetFiles = new HashMap<String, TraceabilityTargetFile>();
    private TraceabilityTargetFile targetFile;
    private int targetFileOffset;

    public TraceabilityTargetFile[] getTargetFiles() {
        Collection<TraceabilityTargetFile> values = this.targetFiles.values();
        return values.toArray(new TraceabilityTargetFile[values.size()]);
    }

    public TraceabilityTargetFile getTargetFile(String path) {
        return this.targetFiles.get(path);
    }

    public void filePathComputed(AcceleoTextGenerationEvent event) {
        String targetPath = new Path(event.getText()).toString();
        this.targetFile = new TraceabilityTargetFile(targetPath);
        this.targetFiles.put(targetPath, this.targetFile);
        this.targetFileOffset = 0;
    }

    public void textGenerated(AcceleoTextGenerationEvent event) {
        if (event.getText() != null && event.getText().length() > 0 && this.targetFile != null && event.getSource() != null) {
            TraceabilityModel templateNode;
            TraceabilityModel model = this.getOrCreateModelInChildren(this.targetFile, event.getSource());
            TraceabilityModel templateRoot = this.getOrCreateModelInChildren(model, EcoreUtil.getRootContainer((EObject)event.getBlock()));
            Block eModuleElement = event.getBlock();
            while (eModuleElement != null && !(eModuleElement instanceof ModuleElement)) {
                eModuleElement = eModuleElement.eContainer();
            }
            if (eModuleElement instanceof ModuleElement) {
                TraceabilityModel templateModuleElement = this.getOrCreateModelInChildren(templateRoot, (EObject)eModuleElement);
                templateNode = eModuleElement == event.getBlock() ? templateModuleElement : this.getOrCreateModelInChildren(templateModuleElement, (EObject)event.getBlock());
            } else {
                templateNode = this.getOrCreateModelInChildren(templateRoot, (EObject)event.getBlock());
            }
            TraceabilityRegion region = new TraceabilityRegion(this.targetFileOffset, event.getText().length(), event.getBlock());
            this.targetFileOffset += event.getText().length();
            templateNode.getRegions().add(region);
            region.setParent(templateNode);
        }
    }

    private TraceabilityModel getOrCreateModelInChildren(TraceabilityContainer parent, EObject eObject) {
        for (TraceabilityModel child : parent.getChildren()) {
            TraceabilityModel result = null;
            if (child.getEObject() == eObject) {
                result = child;
            } else if (this.ancestorOf(child.getEObject(), eObject)) {
                result = this.getOrCreateModelInChildren(child, eObject);
            }
            if (result == null) continue;
            return result;
        }
        TraceabilityModel newModel = eObject instanceof Module ? new TraceabilityTemplate((Module)eObject) : (eObject instanceof TemplateExpression ? new TraceabilityTemplate((TemplateExpression)eObject) : new TraceabilityModel(eObject));
        HashSet<TraceabilityModel> toMove = new HashSet<TraceabilityModel>();
        for (TraceabilityModel sibling : parent.getChildren()) {
            if (!this.ancestorOf(newModel.getEObject(), sibling.getEObject())) continue;
            toMove.add(sibling);
        }
        for (TraceabilityModel next : toMove) {
            this.addInChildren(newModel, next);
            parent.getChildren().remove(next);
        }
        this.addInChildren(parent, newModel);
        return newModel;
    }

    private void addInChildren(TraceabilityContainer parent, TraceabilityModel child) {
        int index = -1;
        if (!(child instanceof TraceabilityTemplate)) {
            int i = 0;
            for (TraceabilityModel otherChild : parent.getChildren()) {
                if (otherChild instanceof TraceabilityTemplate) {
                    index = i;
                    break;
                }
                ++i;
            }
        }
        if (index == -1) {
            parent.getChildren().add(child);
        } else {
            parent.getChildren().add(index, child);
        }
        child.setParent(parent);
    }

    private boolean ancestorOf(EObject ancestor, EObject object) {
        EObject current = object.eContainer();
        while (current != null) {
            if (current == ancestor) {
                return true;
            }
            current = current.eContainer();
        }
        return false;
    }
}

