/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.migration.ui;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.gmf.internal.xpand.RootManager;
import org.eclipse.gmf.internal.xpand.expression.AnalysationIssue;
import org.eclipse.gmf.internal.xpand.migration.MigrationException;
import org.eclipse.gmf.internal.xpand.migration.ui.MigrationVisitor;
import org.eclipse.gmf.internal.xpand.migration.ui.ResourceCountingVisitor;
import org.eclipse.gmf.internal.xpand.migration.ui.XpandResourceMigrationException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class MigrateXpandRoot
implements IObjectActionDelegate {
    private static final String CHARSET = "ISO-8859-1";
    private static final String MIGRATED_ROOT_EXTENSION = "migrated";
    private IContainer selectedContainer;
    private RootManager rootManager;
    private IWorkbenchPart workbenchPart;

    private static IFolder getOutputFolder(IContainer selectedContainer) {
        IContainer parent = selectedContainer.getParent();
        IPath relativePathBasis = selectedContainer.getProjectRelativePath().removeFirstSegments(parent.getProjectRelativePath().segmentCount());
        IPath relativePath = relativePathBasis.addFileExtension(MIGRATED_ROOT_EXTENSION);
        int i = 0;
        while (parent.getFolder(relativePath).exists()) {
            relativePath = relativePathBasis.addFileExtension(MIGRATED_ROOT_EXTENSION + i);
            ++i;
        }
        return parent.getFolder(relativePath);
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.workbenchPart = targetPart;
    }

    public void run(IAction action) {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                monitor.setTaskName("Migrating Xpand Resources");
                monitor.beginTask("Migrating Xpand Resources", 102);
                int totalNumberOfFiles = MigrateXpandRoot.this.calculateFiles(MigrateXpandRoot.this.selectedContainer, new SubProgressMonitor(monitor, 1));
                IFolder newFolder = MigrateXpandRoot.getOutputFolder(MigrateXpandRoot.this.selectedContainer);
                monitor.worked(1);
                IProgressMonitor subProgressMonitor = MigrateXpandRoot.this.createSubProgressMonitor(monitor, null, 100);
                subProgressMonitor.beginTask("Migrating Xpand Resources", totalNumberOfFiles);
                try {
                    MigrateXpandRoot.this.selectedContainer.accept((IResourceVisitor)new MigrationVisitor(MigrateXpandRoot.this.selectedContainer, newFolder, MigrateXpandRoot.this.rootManager, subProgressMonitor));
                }
                catch (CoreException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof InterruptedException) {
                        throw (InterruptedException)cause;
                    }
                    if (cause instanceof XpandResourceMigrationException) {
                        throw new InvocationTargetException(cause);
                    }
                    if (cause instanceof UnsupportedEncodingException) {
                        throw new InvocationTargetException(cause);
                    }
                    throw e;
                }
                monitor.done();
            }
        };
        try {
            new ProgressMonitorDialog(this.getShell()).run(true, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof XpandResourceMigrationException) {
                this.reportMigrationException((XpandResourceMigrationException)cause);
            } else if (cause instanceof UnsupportedEncodingException) {
                this.showError("Unsupported encoding", "Specified encoding \"ISO-8859-1\" is not supported by the platform: " + cause.getMessage());
            } else {
                this.showError("Invocation target exception", e.getMessage());
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    protected IProgressMonitor createSubProgressMonitor(IProgressMonitor monitor, String taskName, int numberOfTicks) throws InterruptedException {
        if (monitor.isCanceled()) {
            throw new InterruptedException("Process was canceled");
        }
        SubProgressMonitor spm = new SubProgressMonitor(monitor, numberOfTicks);
        if (taskName != null) {
            spm.setTaskName(taskName);
        }
        return spm;
    }

    private int calculateFiles(IContainer container, SubProgressMonitor monitor) throws CoreException {
        ResourceCountingVisitor visitor = new ResourceCountingVisitor((IProgressMonitor)monitor);
        container.accept((IResourceVisitor)visitor);
        monitor.done();
        return visitor.getNumberOfSteps();
    }

    private void reportMigrationException(XpandResourceMigrationException ex) {
        MigrationException migrationException = ex.getMigrationException();
        StringBuilder sb = new StringBuilder(ex.getTemplateFile().getProjectRelativePath().toString());
        sb.append(" migration error\n");
        switch (migrationException.getType()) {
            case ANALYZATION_PROBLEMS: {
                sb.append("Following analyzation problems present:\n\n");
                for (AnalysationIssue issue : migrationException.getIssues()) {
                    sb.append(issue.toString());
                    sb.append("\n");
                }
                this.showError("Unable to load xtend resource", sb.toString());
                return;
            }
        }
        this.showError("Migration exception", sb.append(migrationException.getMessage()).toString());
    }

    private void showError(String title, String contents) {
        MessageDialog.openError((Shell)this.getShell(), (String)title, (String)contents);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection structuredSelection;
        if (selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).size() == 1 && structuredSelection.getFirstElement() instanceof IContainer) {
            this.selectedContainer = (IContainer)structuredSelection.getFirstElement();
            this.rootManager = new RootManager(this.selectedContainer.getProject());
            action.setEnabled(this.rootManager.isTemplateRoot(this.selectedContainer));
            return;
        }
        action.setEnabled(false);
    }

    private Shell getShell() {
        return this.workbenchPart.getSite().getShell();
    }
}

