/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.migration;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.gmf.internal.xpand.expression.ast.FeatureCall;
import org.eclipse.gmf.internal.xpand.expression.ast.OperationCall;
import org.eclipse.gmf.internal.xpand.migration.FeatureCallTrace;
import org.eclipse.gmf.internal.xpand.migration.OclKeywordManager;
import org.eclipse.gmf.internal.xpand.migration.OperationCallTrace;
import org.eclipse.gmf.internal.xpand.migration.StandardLibraryImports;

public class ModelManager {
    private StandardLibraryImports stdLibraryImports;
    private OclKeywordManager oclKeywordManager;
    private Set<String> selfVariableAliases = new HashSet<String>();

    public ModelManager(StandardLibraryImports libraryImports) {
        this(libraryImports, new OclKeywordManager());
    }

    public ModelManager(StandardLibraryImports libraryImports, OclKeywordManager keywordManager) {
        this.stdLibraryImports = libraryImports;
        this.oclKeywordManager = keywordManager;
    }

    public String getName(OperationCall operationCall, OperationCallTrace trace) {
        String operationName;
        if ((trace.getType() == OperationCallTrace.Type.OPERATION_REF || trace.getType() == OperationCallTrace.Type.IMPLICIT_COLLECT_OPERATION_REF) && (operationName = this.stdLibraryImports.getOperationName(trace.getEOperation())) != null) {
            return operationName;
        }
        if ((trace.getType() == OperationCallTrace.Type.STATIC_EXTENSION_REF || trace.getType() == OperationCallTrace.Type.EXTENSION_REF || trace.getType() == OperationCallTrace.Type.IMPLICIT_COLLECT_EXTENSION_REF) && trace.getNativeLibraryName() != null) {
            this.stdLibraryImports.registerNativeLibrary(trace.getNativeLibraryName());
        }
        return trace.getType() == OperationCallTrace.Type.OPERATION_REF || trace.getType() == OperationCallTrace.Type.IMPLICIT_COLLECT_OPERATION_REF ? this.oclKeywordManager.getValidIdentifierValue(trace.getEOperation().getName()) : this.oclKeywordManager.getValidIdentifierValue(operationCall.getName());
    }

    public String getName(FeatureCall featureCall, FeatureCallTrace trace) {
        if (trace.getType() == FeatureCallTrace.Type.ENV_VAR_REF && this.selfVariableAliases.contains(featureCall.getName().getValue())) {
            return "self";
        }
        if (trace.getType() == FeatureCallTrace.Type.FEATURE_REF) {
            EStructuralFeature feature = trace.getFeature();
            if (EcorePackage.eINSTANCE.getETypedElement().isSuperTypeOf(feature.getEContainingClass()) && EcorePackage.eINSTANCE.getETypedElement_UpperBound().getFeatureID() == EcorePackage.eINSTANCE.getETypedElement().getFeatureID(feature)) {
                return String.valueOf(this.oclKeywordManager.getValidIdentifierValue(feature.getName())) + ".oclAsType(Integer)";
            }
        }
        return trace.getType() == FeatureCallTrace.Type.FEATURE_REF ? this.oclKeywordManager.getValidIdentifierValue(trace.getFeature().getName()) : this.oclKeywordManager.getValidIdentifierValue(featureCall.getName());
    }

    public OclKeywordManager getOclKeywordManager() {
        return this.oclKeywordManager;
    }

    public void registerSelfAlias(String selfVariableAlias) {
        this.selfVariableAliases.add(selfVariableAlias);
    }

    public void unregisterSelfAlias(String selfVariableAlias) {
        this.selfVariableAliases.remove(selfVariableAlias);
    }
}

