/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.gmf.internal.xpand.BuiltinMetaModel;
import org.eclipse.gmf.internal.xpand.CollectionTypesSupport;

public class CollectionTypesSupportExt {
    static final EClass BAG_TYPE = EcoreFactory.eINSTANCE.createEClass();
    static final EClass ORDEREDSET_TYPE = EcoreFactory.eINSTANCE.createEClass();
    static EClass BAG_OF_OBJECT;
    static EClass ORDEREDSET_OF_OBJECT;
    private final Map<EClassifier, EClass> bagsM1 = new HashMap<EClassifier, EClass>();
    private final Map<EClassifier, EClass> orderedSetsM1 = new HashMap<EClassifier, EClass>();

    void init(EPackage xecore) {
        BAG_TYPE.setName("Bag");
        ORDEREDSET_TYPE.setName("OrderedSet");
        BAG_TYPE.getESuperTypes().add((Object)CollectionTypesSupport.COLLECTION_TYPE);
        ORDEREDSET_TYPE.getESuperTypes().add((Object)CollectionTypesSupport.COLLECTION_TYPE);
        xecore.getEClassifiers().add((Object)BAG_TYPE);
        xecore.getEClassifiers().add((Object)ORDEREDSET_TYPE);
        BAG_OF_OBJECT = CollectionTypesSupportExt.newBagType((EClassifier)EcorePackage.eINSTANCE.getEJavaObject());
        ORDEREDSET_OF_OBJECT = CollectionTypesSupportExt.newOrderedSetType((EClassifier)EcorePackage.eINSTANCE.getEJavaObject());
        this.bagsM1.put(null, CollectionTypesSupportExt.newBagType((EClassifier)BuiltinMetaModel.VOID));
        this.orderedSetsM1.put(null, CollectionTypesSupportExt.newOrderedSetType((EClassifier)BuiltinMetaModel.VOID));
    }

    public boolean isCollectionMetaType(String name) {
        return BAG_TYPE.getName().equals(name) || ORDEREDSET_TYPE.getName().equals(name);
    }

    public EClass getCollectionType(String metaTypeName, EClassifier innerType) {
        assert (this.isCollectionMetaType(metaTypeName));
        if (BAG_TYPE.getName().equals(metaTypeName)) {
            return this.getBagType(innerType);
        }
        if (ORDEREDSET_TYPE.getName().equals(metaTypeName)) {
            return this.getOrderedSetType(innerType);
        }
        throw new IllegalStateException();
    }

    EClass getCollectionType(EClass metaType, EClassifier innerType) {
        if (BAG_TYPE.equals(metaType)) {
            return this.getBagType(innerType);
        }
        if (ORDEREDSET_TYPE.equals(metaType)) {
            return this.getOrderedSetType(innerType);
        }
        throw new IllegalStateException();
    }

    public EClass getBagType(EClassifier innerType) {
        EClass existing = this.bagsM1.get(innerType);
        if (existing == null) {
            existing = CollectionTypesSupportExt.newBagType(innerType);
            this.bagsM1.put(innerType, existing);
        }
        return existing;
    }

    public EClass getOrderedSetType(EClassifier innerType) {
        EClass existing = this.orderedSetsM1.get(innerType);
        if (existing == null) {
            existing = CollectionTypesSupportExt.newOrderedSetType(innerType);
            this.orderedSetsM1.put(innerType, existing);
        }
        return existing;
    }

    private static EClass newBagType(EClassifier innerType) {
        EClass c = BuiltinMetaModel.internalNewParameterizedType(BAG_TYPE, innerType);
        c.getESuperTypes().add((Object)CollectionTypesSupport.COLLECTION_OF_OBJECT);
        return c;
    }

    private static EClass newOrderedSetType(EClassifier innerType) {
        EClass c = BuiltinMetaModel.internalNewParameterizedType(ORDEREDSET_TYPE, innerType);
        c.getESuperTypes().add((Object)CollectionTypesSupport.COLLECTION_OF_OBJECT);
        return c;
    }
}

