/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.examples.runtime.diagram.logic.internal.wizards;

import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gmf.examples.runtime.diagram.logic.internal.l10n.ExampleDiagramLogicMessages;
import org.eclipse.gmf.examples.runtime.diagram.logic.internal.util.LogicDiagramFileCreator;
import org.eclipse.gmf.examples.runtime.diagram.logic.internal.util.LogicEditorUtil;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.ide.wizards.EditorWizardPage;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.util.DiagramFileCreator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.dialogs.ResourceSelectionDialog;

public class LogicWizardPage
extends EditorWizardPage {
    private Button separateSemantics;
    private Text semanticResource;

    public LogicWizardPage(IWorkbench aWorkbench, IStructuredSelection selection) {
        super("LogicDiagramPage", aWorkbench, selection);
        this.setTitle(ExampleDiagramLogicMessages.LogicWizardPage_Title);
        this.setDescription(ExampleDiagramLogicMessages.LogicWizardPage_Description);
    }

    public IFile createAndOpenDiagram(IPath containerPath, String fileName, InputStream initialContents, String kind, IWorkbenchWindow dWindow, IProgressMonitor progressMonitor, boolean saveDiagram) {
        String semanticResourcePath = null;
        if (this.separateSemantics.getSelection() && this.semanticResource.getText().length() > 0) {
            semanticResourcePath = this.semanticResource.getText();
        }
        return LogicEditorUtil.createAndOpenDiagram(this.getDiagramFileCreator(), containerPath, fileName, initialContents, kind, dWindow, progressMonitor, this.isOpenNewlyCreatedDiagramEditor(), saveDiagram, semanticResourcePath);
    }

    protected String getDefaultFileName() {
        return ExampleDiagramLogicMessages.LogicVisualizer_DefaultLogicDiagramFileName;
    }

    public DiagramFileCreator getDiagramFileCreator() {
        return LogicDiagramFileCreator.getInstance();
    }

    protected String getDiagramKind() {
        return "logic";
    }

    protected void createAdvancedControls(Composite parent) {
        super.createAdvancedControls(parent);
        this.separateSemantics = new Button(parent, 32);
        this.separateSemantics.setText(ExampleDiagramLogicMessages.LogicWizardPage_StoreSemanticsSeparately);
        this.separateSemantics.setSelection(false);
        Composite separateSemanticsGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        separateSemanticsGroup.setLayout((Layout)layout);
        GridData data = new GridData(768);
        separateSemanticsGroup.setLayoutData((Object)data);
        this.semanticResource = new Text(separateSemanticsGroup, 2048);
        data = new GridData(768);
        data.widthHint = 200;
        data.horizontalSpan = 2;
        this.semanticResource.setLayoutData((Object)data);
        this.semanticResource.setEnabled(false);
        final Button browseButton = new Button(separateSemanticsGroup, 8);
        browseButton.setText(ExampleDiagramLogicMessages.LogicWizardPage_BrowseSemanticResource);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                LogicWizardPage.this.handleBrowseButtonPressed();
            }
        });
        browseButton.setEnabled(false);
        this.setButtonLayoutData(browseButton);
        this.separateSemantics.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                LogicWizardPage.this.semanticResource.setEnabled(!LogicWizardPage.this.semanticResource.getEnabled());
                browseButton.setEnabled(!browseButton.getEnabled());
                LogicWizardPage.this.semanticResource.setText(LogicWizardPage.this.getContainerFullPath().append(LogicWizardPage.this.getFileName()).removeFileExtension().addFileExtension("logic2semantic").toString());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void handleBrowseButtonPressed() {
        ResourceSelectionDialog dialog = new ResourceSelectionDialog(this.getShell(), (IAdaptable)ResourcesPlugin.getWorkspace().getRoot(), ExampleDiagramLogicMessages.LogicWizardPage_BrowseSemanticDialogTitle);
        if (dialog.open() == 0) {
            if (dialog.getResult().length == 0) {
                return;
            }
            IResource r = (IResource)dialog.getResult()[0];
            this.semanticResource.setText(r.getFullPath().toString());
        }
    }
}

