/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.examples.runtime.diagram.logic.internal.editparts;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.examples.runtime.diagram.logic.internal.editparts.ITerminalOwnerEditPart;
import org.eclipse.gmf.examples.runtime.diagram.logic.internal.figures.LogicColorConstants;
import org.eclipse.gmf.examples.runtime.diagram.logic.internal.util.StringConstants;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.AbstractBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.BorderItemLocator;
import org.eclipse.gmf.runtime.diagram.ui.figures.IBorderItemLocator;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.PropertiesSetStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.graphics.Color;

public class TerminalEditPart
extends AbstractBorderItemEditPart {
    private BorderItemLocator locator;

    public TerminalEditPart(View view) {
        super(view);
    }

    protected NodeFigure createNodeFigure() {
        EditPart host = this.getParent();
        if (host instanceof ITerminalOwnerEditPart) {
            return ((ITerminalOwnerEditPart)host).createOwnedTerminalFigure(this);
        }
        return null;
    }

    public boolean isSelectable() {
        return false;
    }

    public void activate() {
        super.activate();
        Insets parentInset = new Insets(0);
        IFigure fig = ((BorderItemLocator)this.getLocator()).getParentFigure();
        if (fig != null) {
            parentInset = fig.getInsets();
        }
        Rectangle rBounds = ((NodeFigure)this.getFigure()).getHandleBounds();
        ((BorderItemLocator)this.getLocator()).setBorderItemOffset(new Dimension(rBounds.width / 2 + parentInset.getWidth() / 2, rBounds.height / 2 + parentInset.getHeight() / 2));
    }

    public IBorderItemLocator getLocator() {
        return this.locator;
    }

    public void setLocator(BorderItemLocator locator) {
        this.locator = locator;
    }

    public Object getPreferredValue(EStructuralFeature feature) {
        if (feature == NotationPackage.eINSTANCE.getFillStyle_FillColor()) {
            return FigureUtilities.colorToInteger((Color)LogicColorConstants.connectorGreen);
        }
        if (feature == NotationPackage.eINSTANCE.getLineStyle_LineColor()) {
            return FigureUtilities.colorToInteger((Color)LogicColorConstants.logicBlack);
        }
        return super.getPreferredValue(feature);
    }

    protected void refreshBackgroundColor() {
        PropertiesSetStyle propertiesStyle;
        View view = ViewUtil.getViewContainer((EObject)this.getNotationView());
        if (view != null && (propertiesStyle = (PropertiesSetStyle)view.getNamedStyle(NotationPackage.eINSTANCE.getPropertiesSetStyle(), StringConstants.PORTS_PROPERTIES_STYLE_NAME)) != null && propertiesStyle.hasProperty(StringConstants.PORTS_COLOR_PROPERTY_NAME)) {
            try {
                Integer value = (Integer)propertiesStyle.getProperty(StringConstants.PORTS_COLOR_PROPERTY_NAME);
                if (value != null) {
                    this.getFigure().setBackgroundColor(FigureUtilities.integerToColor((Integer)value));
                    return;
                }
            }
            catch (Exception exception) {
                super.refreshBackgroundColor();
            }
        }
        super.refreshBackgroundColor();
    }

    public void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
    }
}

