/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.figures;

import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;

public class HashedCircle
extends Ellipse {
    private HashType hashType = HashType.X;

    public HashedCircle(HashType hashType, int radius) {
        this.hashType = hashType;
        int width = radius * 2;
        this.setSize(new Dimension(width, width));
        this.setMaximumSize(new Dimension(width, width));
    }

    protected void outlineShape(Graphics graphics) {
        super.outlineShape(graphics);
        double radius = (double)this.getBounds().width / 2.0;
        int xyShift = new Double(radius / Math.sqrt(2.0)).intValue();
        Point center = this.getBounds().getCenter();
        if (this.hashType == HashType.X || this.hashType == HashType.BACKSLASH) {
            Point topLeft = center.getTranslated(-xyShift, -xyShift);
            Point bottomRight = center.getTranslated(xyShift, xyShift);
            graphics.drawLine(topLeft, bottomRight);
        }
        if (this.hashType == HashType.X) {
            Point topRight = center.getTranslated(xyShift, -xyShift);
            Point bottomLeft = center.getTranslated(-xyShift, xyShift);
            graphics.drawLine(bottomLeft, topRight);
        }
    }

    public static final class HashType {
        public static final HashType X = new HashType();
        public static final HashType BACKSLASH = new HashType();

        private HashType() {
        }
    }
}

