/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.io;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataOutput;
import org.eclipse.net4j.util.io.StringIO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringCompressor
implements StringIO {
    private static final boolean DEBUG = false;
    private static final byte DEBUG_STRING = 0;
    private static final byte DEBUG_INT = 1;
    private static final byte DEBUG_BYTE = 2;
    private static final int NULL_ID = 0;
    private static final int INFO_FOLLOWS = Integer.MIN_VALUE;
    private static final byte NOTHING_FOLLOWS = 0;
    private static final byte STRING_FOLLOWS = 1;
    private static final byte ACK_FOLLOWS = 2;
    private boolean client;
    private int lastID;
    private Map<String, ID> stringToID = new HashMap<String, ID>();
    private Map<Integer, String> idToString = new HashMap<Integer, String>();
    private List<Integer> pendingAcknowledgements = new ArrayList<Integer>();
    private Object lock = new Object();

    public StringCompressor(boolean client) {
        this.client = client;
    }

    public boolean isClient() {
        return this.client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(ExtendedDataOutput out, String string) throws IOException {
        ID id;
        if (string == null) {
            this.writeInt(out, 0);
            return;
        }
        List<Integer> acknowledgements = null;
        boolean stringFollows = false;
        Object object = this.lock;
        synchronized (object) {
            id = this.stringToID.get(string);
            if (id == null) {
                this.lastID += this.client ? 1 : -1;
                id = new ID(this.lastID);
                this.stringToID.put(string, id);
                this.idToString.put(id.getValue(), string);
                stringFollows = true;
            } else if (!id.isAcknowledged()) {
                stringFollows = true;
            }
            if (!this.pendingAcknowledgements.isEmpty()) {
                acknowledgements = this.pendingAcknowledgements;
                this.pendingAcknowledgements = new ArrayList<Integer>();
            }
        }
        if (stringFollows || acknowledgements != null) {
            this.writeInt(out, Integer.MIN_VALUE);
            this.writeInt(out, id.getValue());
            if (stringFollows) {
                this.writeByte(out, (byte)1);
                this.writeString(out, string);
            }
            if (acknowledgements != null) {
                for (int ack : acknowledgements) {
                    this.writeByte(out, (byte)2);
                    this.writeInt(out, ack);
                }
            }
            this.writeByte(out, (byte)0);
        } else {
            this.writeInt(out, id.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String read(ExtendedDataInput in) throws IOException {
        int id = this.readInt(in);
        if (id == 0) {
            return null;
        }
        String string = null;
        ArrayList<Integer> acks = null;
        if (id == Integer.MIN_VALUE) {
            id = this.readInt(in);
            boolean moreInfos = true;
            while (moreInfos) {
                byte info = this.readByte(in);
                switch (info) {
                    case 0: {
                        moreInfos = false;
                        break;
                    }
                    case 1: {
                        string = this.readString(in);
                        break;
                    }
                    case 2: {
                        if (acks == null) {
                            acks = new ArrayList<Integer>();
                        }
                        acks.add(this.readInt(in));
                        break;
                    }
                    default: {
                        throw new IOException("Invalid info: " + info);
                    }
                }
            }
        }
        Object object = this.lock;
        synchronized (object) {
            if (string != null) {
                this.acknowledge(acks);
                this.stringToID.put(string, new ID(id));
                this.idToString.put(id, string);
                this.pendingAcknowledgements.add(id);
            } else {
                this.acknowledge(acks);
                string = this.idToString.get(id);
                if (string == null) {
                    throw new IOException("String ID unknown: " + id);
                }
            }
        }
        return string;
    }

    public String toString() {
        return MessageFormat.format("StringCompressor[client={0}]", this.client);
    }

    private void acknowledge(List<Integer> acks) {
        if (acks != null) {
            for (int value : acks) {
                ID id;
                String string = this.idToString.get(value);
                if (string == null || (id = this.stringToID.get(string)) == null) continue;
                id.setAcknowledged();
            }
        }
    }

    private void writeByte(ExtendedDataOutput out, byte value) throws IOException {
        out.writeByte(value);
    }

    private void writeInt(ExtendedDataOutput out, int value) throws IOException {
        out.writeInt(value);
    }

    private void writeString(ExtendedDataOutput out, String value) throws IOException {
        out.writeString(value);
    }

    private byte readByte(ExtendedDataInput in) throws IOException {
        return in.readByte();
    }

    private int readInt(ExtendedDataInput in) throws IOException {
        return in.readInt();
    }

    private String readString(ExtendedDataInput in) throws IOException {
        return in.readString();
    }

    private static final class ID {
        private int value;
        private boolean acknowledged;

        public ID(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public boolean isAcknowledged() {
            return this.acknowledged;
        }

        public void setAcknowledged() {
            this.acknowledged = true;
        }
    }
}

