/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.ui.views;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.net4j.util.container.ContainerEventAdapter;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.event.EventUtil;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.ILifecycleState;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.ui.views.IElementFilter;
import org.eclipse.net4j.util.ui.views.ItemProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerItemProvider<CONTAINER extends IContainer<Object>>
extends ItemProvider<CONTAINER> {
    private Map<Object, Node> nodes = new HashMap<Object, Node>();
    private Node root;
    private IElementFilter rootElementFilter;

    public ContainerItemProvider() {
    }

    public ContainerItemProvider(IElementFilter rootElementFilter) {
        this.rootElementFilter = rootElementFilter;
    }

    public IElementFilter getRootElementFilter() {
        return this.rootElementFilter;
    }

    @Override
    public boolean hasChildren(Object element) {
        try {
            Node node = this.getNode(element);
            return !node.getChildren().isEmpty();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public Object[] getChildren(Object element) {
        try {
            Node node = this.getNode(element);
            List<Node> children = node.getChildren();
            Iterator<Node> it = children.iterator();
            while (it.hasNext()) {
                Node child = it.next();
                if (child.isDisposed()) {
                    it.remove();
                    continue;
                }
                Object childElement = child.getElement();
                ILifecycleState lifecycleState = LifecycleUtil.getLifecycleState((Object)childElement);
                if (lifecycleState != ILifecycleState.INACTIVE && lifecycleState != ILifecycleState.DEACTIVATING) continue;
                it.remove();
                child.dispose();
            }
            Object[] result = new Object[children.size()];
            int i = 0;
            while (i < result.length) {
                result[i] = children.get(i).getElement();
                ++i;
            }
            return result;
        }
        catch (RuntimeException runtimeException) {
            return NO_ELEMENTS;
        }
    }

    public Object getParent(Object element) {
        try {
            Node node = this.getNode(element);
            Node parentNode = node.getParent();
            return parentNode == null ? null : parentNode.getElement();
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    protected void connectInput(CONTAINER input) {
        this.root = this.createNode(null, input);
        if (this.root != null) {
            this.addNode(input, this.root);
        }
    }

    @Override
    protected void disconnectInput(CONTAINER input) {
        this.root.dispose();
        this.root = null;
        this.nodes.clear();
    }

    protected void elementAdded(Object element, Object parent) {
    }

    protected void elementRemoved(Object element, Object parent) {
    }

    protected Node getRoot() {
        return this.root;
    }

    protected Map<Object, Node> getNodes() {
        return this.nodes;
    }

    protected Node getNode(Object element) {
        Node node = this.root;
        if (element != this.getInput()) {
            node = this.nodes.get(element);
        }
        if (node == null) {
            throw new IllegalStateException("No node for " + element);
        }
        return node;
    }

    protected Node createNode(Node parent, Object element) {
        if (element instanceof IContainer) {
            return this.createContaineNode(parent, element);
        }
        return this.createLeafNode(parent, element);
    }

    protected LeafNode createLeafNode(Node parent, Object element) {
        return new LeafNode(parent, element);
    }

    protected ContainerNode createContaineNode(Node parent, Object element) {
        return new ContainerNode(parent, (IContainer<Object>)((IContainer)element));
    }

    protected void addNode(Object element, Node node) {
        this.nodes.put(element, node);
    }

    protected Node removeNode(Object element) {
        return this.nodes.remove(element);
    }

    protected boolean filterRootElement(Object element) {
        if (this.rootElementFilter != null) {
            return this.rootElementFilter.filter(element);
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class AbstractContainerNode
    extends AbstractNode {
        private List<Node> children;
        protected IListener containerListener;

        public AbstractContainerNode(Node parent) {
            super(parent);
            this.containerListener = new ContainerEventAdapter<Object>(){

                protected void onAdded(IContainer<Object> container, Object element) {
                    AbstractContainerNode.this.onAdded(container, element);
                }

                protected void onRemoved(IContainer<Object> container, Object element) {
                    AbstractContainerNode.this.onRemoved(container, element);
                }

                protected void notifyOtherEvent(IEvent event) {
                    ContainerItemProvider.this.updateLabels(event.getSource());
                }
            };
        }

        @Override
        public void dispose() {
            if (!this.isDisposed()) {
                if (this.children != null) {
                    for (Node child : this.children) {
                        child.dispose();
                    }
                    this.children.clear();
                    this.children = null;
                    this.containerListener = null;
                }
                super.dispose();
            }
        }

        @Override
        public final List<Node> getChildren() {
            this.checkNotDisposed();
            if (this.children == null) {
                this.children = this.createChildren();
            }
            return this.children;
        }

        public IContainer<Object> getContainer() {
            return (IContainer)this.getElement();
        }

        protected List<Node> createChildren() {
            Object[] elements = this.getContainer().getElements();
            ArrayList<Node> children = new ArrayList<Node>(elements.length);
            int i = 0;
            while (i < elements.length) {
                Object element = elements[i];
                this.addChild(children, element);
                ++i;
            }
            this.getContainer().addListener(this.containerListener);
            return children;
        }

        protected void onAdded(IContainer<Object> container, Object element) {
            Node node = this.addChild(this.getChildren(), element);
            if (node != null) {
                ContainerItemProvider.this.refreshElement(container, true);
                ContainerItemProvider.this.revealElement(element);
                ContainerItemProvider.this.elementAdded(element, container);
            }
        }

        protected void onRemoved(IContainer<Object> container, Object element) {
            Node node = ContainerItemProvider.this.removeNode(element);
            if (node != null) {
                this.getChildren().remove(node);
                ContainerItemProvider.this.elementRemoved(element, container);
                Object rootElement = ContainerItemProvider.this.root.getElement();
                IContainer<Object> refreshElement = container == rootElement ? null : container;
                ContainerItemProvider.this.refreshElement(refreshElement, true);
                node.dispose();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class AbstractNode
    implements Node {
        private Node parent;
        private boolean disposed;

        public AbstractNode(Node parent) {
            this.parent = parent;
        }

        @Override
        public void dispose() {
            if (!this.disposed) {
                ContainerItemProvider.this.removeNode(this.getElement());
                this.parent = null;
                this.disposed = true;
            }
        }

        @Override
        public boolean isDisposed() {
            return this.disposed;
        }

        public String toString() {
            return MessageFormat.format("{0}[{1}]", this.getClass().getSimpleName(), this.getElement());
        }

        @Override
        public final Node getParent() {
            this.checkNotDisposed();
            return this.parent;
        }

        @Override
        public TreePath getTreePath() {
            TreePath parentPath = this.parent == null ? TreePath.EMPTY : this.parent.getTreePath();
            return parentPath.createChildPath(this.getElement());
        }

        protected void checkNotDisposed() {
            if (this.disposed) {
                throw new IllegalStateException("Node is already disposed of");
            }
        }

        protected Node addChild(Collection<Node> children, Object element) {
            Node node;
            if (ContainerItemProvider.this.nodes.containsKey(element)) {
                return null;
            }
            if ((this != ContainerItemProvider.this.root || ContainerItemProvider.this.filterRootElement(element)) && (node = ContainerItemProvider.this.createNode(this, element)) != null) {
                ContainerItemProvider.this.addNode(element, node);
                children.add(node);
                return node;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ContainerNode
    extends AbstractContainerNode {
        private IContainer<Object> container;

        public ContainerNode(Node parent, IContainer<Object> container) {
            super(parent);
            this.container = container;
            if (container == null) {
                throw new IllegalArgumentException("container == null");
            }
        }

        @Override
        public void dispose() {
            if (!this.isDisposed()) {
                this.container.removeListener(this.containerListener);
                this.container = null;
                super.dispose();
            }
        }

        @Override
        public Object getElement() {
            return this.container;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class LeafNode
    extends AbstractNode
    implements IListener {
        private Object element;

        public LeafNode(Node parent, Object element) {
            super(parent);
            this.element = element;
            EventUtil.addListener((Object)element, (IListener)this);
        }

        @Override
        public void dispose() {
            if (!this.isDisposed()) {
                EventUtil.removeListener((Object)this.element, (IListener)this);
                this.element = null;
                super.dispose();
            }
        }

        @Override
        public Object getElement() {
            this.checkNotDisposed();
            return this.element;
        }

        @Override
        public List<Node> getChildren() {
            this.checkNotDisposed();
            return Collections.emptyList();
        }

        public void notifyEvent(IEvent event) {
            ContainerItemProvider.this.updateLabels(event.getSource());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Node {
        public void dispose();

        public boolean isDisposed();

        public Object getElement();

        public Node getParent();

        public List<Node> getChildren();

        public TreePath getTreePath();
    }
}

