/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.jms.util;

import java.io.IOException;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import org.eclipse.net4j.internal.jms.BytesMessageImpl;
import org.eclipse.net4j.internal.jms.MapMessageImpl;
import org.eclipse.net4j.internal.jms.MessageImpl;
import org.eclipse.net4j.internal.jms.ObjectMessageImpl;
import org.eclipse.net4j.internal.jms.StreamMessageImpl;
import org.eclipse.net4j.internal.jms.TextMessageImpl;
import org.eclipse.net4j.internal.jms.bundle.OM;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public final class MessageUtil {
    private static final ContextTracer PROTOCOL = new ContextTracer(OM.DEBUG_PROTOCOL, MessageUtil.class);

    private MessageUtil() {
    }

    public static byte getType(Message message) {
        if (message instanceof BytesMessage) {
            return 1;
        }
        if (message instanceof MapMessage) {
            return 2;
        }
        if (message instanceof ObjectMessage) {
            return 3;
        }
        if (message instanceof StreamMessage) {
            return 4;
        }
        if (message instanceof TextMessage) {
            return 5;
        }
        throw new IllegalArgumentException("message: " + message);
    }

    public static String getTypeName(byte type) {
        switch (type) {
            case 1: {
                return "BYTES_MESSAGE";
            }
            case 2: {
                return "MAP_MESSAGE";
            }
            case 3: {
                return "OBJECT_MESSAGE";
            }
            case 4: {
                return "STREAM_MESSAGE";
            }
            case 5: {
                return "TEXT_MESSAGE";
            }
        }
        throw new IllegalArgumentException("type: " + type);
    }

    public static MessageImpl create(byte type) {
        switch (type) {
            case 1: {
                return new BytesMessageImpl();
            }
            case 2: {
                return new MapMessageImpl();
            }
            case 3: {
                return new ObjectMessageImpl();
            }
            case 4: {
                return new StreamMessageImpl();
            }
            case 5: {
                return new TextMessageImpl();
            }
        }
        throw new IllegalArgumentException("type: " + type);
    }

    public static MessageImpl copy(Message source) throws JMSException {
        byte type = MessageUtil.getType(source);
        MessageImpl result = MessageUtil.create(type);
        result.populate(source);
        return result;
    }

    public static MessageImpl convert(Message source) throws JMSException {
        if (source instanceof MessageImpl) {
            return (MessageImpl)source;
        }
        return MessageUtil.copy(source);
    }

    public static void write(ExtendedDataOutputStream out, MessageImpl message) throws IOException {
        byte type = MessageUtil.getType(message);
        if (PROTOCOL.isEnabled()) {
            PROTOCOL.format("Writing {0}", new Object[]{MessageUtil.getTypeName(type)});
        }
        out.writeByte((int)type);
        message.write(out);
    }

    public static MessageImpl read(ExtendedDataInputStream in) throws IOException {
        byte type = in.readByte();
        if (PROTOCOL.isEnabled()) {
            PROTOCOL.format("Reading {0}", new Object[]{MessageUtil.getTypeName(type)});
        }
        MessageImpl message = MessageUtil.create(type);
        message.read(in);
        return message;
    }
}

