/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.samples.emf.sample.epo2.impl;

import java.util.Date;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.teneo.samples.emf.sample.epo2.Customer;
import org.eclipse.emf.teneo.samples.emf.sample.epo2.EPO2Factory;
import org.eclipse.emf.teneo.samples.emf.sample.epo2.EPO2Package;
import org.eclipse.emf.teneo.samples.emf.sample.epo2.GlobalAddress;
import org.eclipse.emf.teneo.samples.emf.sample.epo2.GlobalLocation;
import org.eclipse.emf.teneo.samples.emf.sample.epo2.Item;
import org.eclipse.emf.teneo.samples.emf.sample.epo2.OrderStatus;
import org.eclipse.emf.teneo.samples.emf.sample.epo2.PurchaseOrder;
import org.eclipse.emf.teneo.samples.emf.sample.epo2.Supplier;
import org.eclipse.emf.teneo.samples.emf.sample.epo2.USAddress;
import org.eclipse.emf.teneo.samples.emf.sample.epo2.impl.CustomerImpl;
import org.eclipse.emf.teneo.samples.emf.sample.epo2.impl.GlobalAddressImpl;
import org.eclipse.emf.teneo.samples.emf.sample.epo2.impl.GlobalLocationImpl;
import org.eclipse.emf.teneo.samples.emf.sample.epo2.impl.ItemImpl;
import org.eclipse.emf.teneo.samples.emf.sample.epo2.impl.PurchaseOrderImpl;
import org.eclipse.emf.teneo.samples.emf.sample.epo2.impl.SupplierImpl;
import org.eclipse.emf.teneo.samples.emf.sample.epo2.impl.USAddressImpl;

public class EPO2FactoryImpl
extends EFactoryImpl
implements EPO2Factory {
    public static EPO2Factory init() {
        try {
            EPO2Factory theEPO2Factory = (EPO2Factory)EPackage.Registry.INSTANCE.getEFactory("http://www.eclipse.org/emf/teneo/samples/emf/extendedpo2");
            if (theEPO2Factory != null) {
                return theEPO2Factory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new EPO2FactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createItem();
            }
            case 1: {
                return this.createUSAddress();
            }
            case 2: {
                return this.createPurchaseOrder();
            }
            case 4: {
                return this.createSupplier();
            }
            case 5: {
                return this.createCustomer();
            }
            case 6: {
                return this.createGlobalAddress();
            }
            case 7: {
                return this.createGlobalLocation();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 8: {
                return this.createOrderStatusFromString(eDataType, initialValue);
            }
            case 9: {
                return this.createSKUFromString(eDataType, initialValue);
            }
            case 10: {
                return this.createDateFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 8: {
                return this.convertOrderStatusToString(eDataType, instanceValue);
            }
            case 9: {
                return this.convertSKUToString(eDataType, instanceValue);
            }
            case 10: {
                return this.convertDateToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public Item createItem() {
        ItemImpl item = new ItemImpl();
        return item;
    }

    public USAddress createUSAddress() {
        USAddressImpl usAddress = new USAddressImpl();
        return usAddress;
    }

    public PurchaseOrder createPurchaseOrder() {
        PurchaseOrderImpl purchaseOrder = new PurchaseOrderImpl();
        return purchaseOrder;
    }

    public Supplier createSupplier() {
        SupplierImpl supplier = new SupplierImpl();
        return supplier;
    }

    public Customer createCustomer() {
        CustomerImpl customer = new CustomerImpl();
        return customer;
    }

    public GlobalAddress createGlobalAddress() {
        GlobalAddressImpl globalAddress = new GlobalAddressImpl();
        return globalAddress;
    }

    public GlobalLocation createGlobalLocation() {
        GlobalLocationImpl globalLocation = new GlobalLocationImpl();
        return globalLocation;
    }

    public OrderStatus createOrderStatusFromString(EDataType eDataType, String initialValue) {
        OrderStatus result = OrderStatus.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertOrderStatusToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public String createSKUFromString(EDataType eDataType, String initialValue) {
        return (String)super.createFromString(initialValue);
    }

    public String convertSKUToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(instanceValue);
    }

    public Date createDateFromString(EDataType eDataType, String initialValue) {
        return (Date)super.createFromString(initialValue);
    }

    public String convertDateToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(instanceValue);
    }

    public EPO2Package getEPO2Package() {
        return (EPO2Package)this.getEPackage();
    }

    @Deprecated
    public static EPO2Package getPackage() {
        return EPO2Package.eINSTANCE;
    }
}

