/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate.mapping.eav;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.teneo.hibernate.mapping.eav.EAVBlobValue;
import org.eclipse.emf.teneo.hibernate.mapping.eav.EAVTextValue;
import org.eclipse.emf.teneo.hibernate.mapping.eav.EAVValueHolder;

public class EAVSingleEAttributeValueHolder
extends EAVValueHolder {
    private String type;
    private String typeNeutralValue;
    private String stringValue;
    private Date dateValue;
    private BigDecimal numericValue;
    private long longValue;
    private Object objectValue;
    private EAVBlobValue blobValue;
    private EAVTextValue textValue;

    public void set(Object value) {
        this.stringValue = null;
        this.dateValue = null;
        this.numericValue = null;
        this.longValue = 0L;
        this.setValueIsSet(false);
        this.setMandatoryValue(null);
        this.objectValue = value;
        if (value == null) {
            return;
        }
        this.setMandatoryValue(NOT_NULL_VALUE);
        boolean isBlob = value instanceof byte[] || value instanceof String && this.isClob((EModelElement)this.getEStructuralFeature());
        EDataType eDataType = (EDataType)this.getEStructuralFeature().getEType();
        if (value != null) {
            EFactory eFactory = eDataType.getEPackage().getEFactoryInstance();
            if (!isBlob) {
                this.typeNeutralValue = eFactory.convertToString(eDataType, value);
            }
            this.type = value.getClass().getName();
        } else {
            this.type = eDataType.getInstanceClassName();
            this.typeNeutralValue = null;
            this.blobValue = null;
            this.textValue = null;
        }
        if (value instanceof byte[]) {
            this.blobValue = new EAVBlobValue();
            this.blobValue.setBlobValue((byte[])value);
            this.blobValue.setValueHolder(this);
        } else if (value instanceof Enumerator) {
            this.stringValue = ((Enumerator)value).getName();
        } else if (value instanceof String && isBlob) {
            this.textValue = new EAVTextValue();
            this.textValue.setTextValue((String)value);
            this.textValue.setValueHolder(this);
        } else if (value instanceof String) {
            this.stringValue = (String)value;
        } else if (value instanceof Date) {
            this.dateValue = (Date)value;
        } else if (value instanceof Number) {
            if (value instanceof BigDecimal) {
                this.numericValue = (BigDecimal)value;
            } else if (value instanceof BigInteger) {
                this.longValue = ((BigInteger)value).longValue();
            } else if (value instanceof Double || value instanceof Float) {
                this.numericValue = new BigDecimal(((Number)value).doubleValue());
            } else if (value instanceof Integer || value instanceof Long || value instanceof Short || value instanceof Byte) {
                this.longValue = ((Number)value).longValue();
            } else {
                throw new UnsupportedOperationException("Primitive type " + value.getClass() + " not supported here.");
            }
        }
    }

    public Object get(InternalEObject owner) {
        if (this.objectValue == null && this.blobValue != null) {
            this.objectValue = this.blobValue.getBlobValue();
        } else if (this.objectValue == null && this.textValue != null) {
            this.objectValue = this.textValue.getTextValue();
        } else if (this.objectValue == null && this.typeNeutralValue != null) {
            EDataType eDataType = (EDataType)this.getEStructuralFeature().getEType();
            EFactory eFactory = eDataType.getEPackage().getEFactoryInstance();
            this.objectValue = eFactory.createFromString(eDataType, this.typeNeutralValue);
        }
        return this.objectValue;
    }

    public Object getValue() {
        return this.get(null);
    }

    public void setValueInOwner(InternalEObject owner) {
        if (this.getEStructuralFeature().isUnsettable() && !this.isValueIsSet()) {
            owner.eUnset(this.getEStructuralFeature());
        } else {
            owner.eSet(this.getEStructuralFeature(), this.get(owner));
        }
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public void setStringValue(String stringValue) {
        this.stringValue = stringValue;
    }

    public Date getDateValue() {
        return this.dateValue;
    }

    public void setDateValue(Date dateValue) {
        this.dateValue = dateValue;
    }

    public BigDecimal getNumericValue() {
        return this.numericValue;
    }

    public void setNumericValue(BigDecimal numericValue) {
        this.numericValue = numericValue;
    }

    public long getLongValue() {
        return this.longValue;
    }

    public void setLongValue(long longValue) {
        this.longValue = longValue;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getTypeNeutralValue() {
        return this.typeNeutralValue;
    }

    public void setTypeNeutralValue(String typeNeutralValue) {
        this.typeNeutralValue = typeNeutralValue;
    }

    public EAVBlobValue getBlobValue() {
        return this.blobValue;
    }

    public void setBlobValue(EAVBlobValue blobValue) {
        this.blobValue = blobValue;
    }

    public EAVTextValue getTextValue() {
        return this.textValue;
    }

    public void setTextValue(EAVTextValue textValue) {
        this.textValue = textValue;
    }

    private boolean isClob(EModelElement modelElement) {
        EAnnotation eAnnotation = modelElement.getEAnnotation("teneo.jpa");
        if (eAnnotation == null) {
            return false;
        }
        for (String str : eAnnotation.getDetails().values()) {
            if (!str.contains("@Lob")) continue;
            return true;
        }
        if (modelElement instanceof EAttribute) {
            return this.isClob((EModelElement)((EAttribute)modelElement).getEAttributeType());
        }
        return false;
    }
}

