/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate.mapping;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.emf.teneo.hibernate.HbStoreException;
import org.eclipse.emf.teneo.hibernate.mapping.XSDDateTime;
import org.eclipse.emf.teneo.util.EcoreDataTypes;
import org.hibernate.HibernateException;

public class XSDDate
extends XSDDateTime {
    static final long serialVersionUID = 1L;
    private final DatatypeFactory dataTypeFactory;

    public XSDDate() {
        try {
            this.dataTypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new HbStoreException("Exception ", e);
        }
    }

    public int sqlType() {
        return 91;
    }

    public String getName() {
        return "xmldate";
    }

    public Object get(ResultSet resultSet, String name) throws SQLException {
        java.sql.Date date = resultSet.getDate(name);
        if (date == null) {
            return null;
        }
        return EcoreDataTypes.INSTANCE.getXMLGregorianCalendar((Date)date);
    }

    public void set(PreparedStatement statement, Object value, int index) throws SQLException {
        java.sql.Date d = new java.sql.Date(((XMLGregorianCalendar)value).toGregorianCalendar().getTime().getTime());
        statement.setDate(index, d);
    }

    public Object fromStringValue(String s) throws HibernateException {
        return this.dataTypeFactory.newXMLGregorianCalendar(s);
    }
}

