/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.teneo.extension.ExtensionInitializable;
import org.eclipse.emf.teneo.extension.ExtensionManager;
import org.eclipse.emf.teneo.extension.ExtensionManagerAware;
import org.eclipse.emf.teneo.extension.ExtensionPoint;
import org.eclipse.emf.teneo.hibernate.HbStoreException;
import org.eclipse.emf.teneo.mapping.elist.PersistableDelegateList;
import org.eclipse.emf.teneo.mapping.strategy.EntityNameStrategy;
import org.eclipse.emf.teneo.util.FieldUtil;
import org.hibernate.EmptyInterceptor;
import org.hibernate.collection.AbstractPersistentCollection;

public class EMFInterceptor
extends EmptyInterceptor
implements ExtensionPoint,
ExtensionManagerAware,
ExtensionInitializable {
    private static ThreadLocal<List<AbstractPersistentCollection>> persistentCollections = new ThreadLocal();
    private static final Field sessionField = FieldUtil.getField(AbstractPersistentCollection.class, (String)"session");
    private static final long serialVersionUID = 1680117509182298808L;
    private EntityNameStrategy qualifyStrategy;
    private ExtensionManager extensionManager;

    public static void registerCollectionsForDereferencing(EObject eObject) {
        for (EReference eReference : eObject.eClass().getEAllReferences()) {
            Object delegate;
            Object refValue;
            if (!eReference.isMany() || !((refValue = eObject.eGet((EStructuralFeature)eReference)) instanceof PersistableDelegateList) || !((delegate = ((PersistableDelegateList)refValue).getDelegate()) instanceof AbstractPersistentCollection)) continue;
            if (persistentCollections.get() == null) {
                persistentCollections.set(new ArrayList());
            }
            List<AbstractPersistentCollection> list = persistentCollections.get();
            list.add((AbstractPersistentCollection)delegate);
        }
    }

    public void setExtensionManager(ExtensionManager extensionManager) {
        this.extensionManager = extensionManager;
    }

    public void initializeExtension() {
        this.qualifyStrategy = (EntityNameStrategy)this.extensionManager.getExtension(EntityNameStrategy.class);
    }

    public String getEntityName(Object object) {
        if (object instanceof EObject) {
            EObject eobj = (EObject)object;
            return this.qualifyStrategy.toEntityName(eobj.eClass());
        }
        return super.getEntityName(object);
    }

    public void postFlush(Iterator entities) {
        List<AbstractPersistentCollection> list = persistentCollections.get();
        if (list == null) {
            return;
        }
        try {
            for (AbstractPersistentCollection apc : list) {
                try {
                    sessionField.set(apc, null);
                }
                catch (Exception e) {
                    throw new HbStoreException(e);
                }
            }
        }
        finally {
            persistentCollections.set(null);
        }
    }
}

