/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.editor.ui;

import java.io.IOException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.QvtCodeReader;

public class QvtPairMatcher
implements ICharacterPairMatcher {
    protected char[] myPairs;
    protected IDocument myDocument;
    protected int myOffset;
    protected int myStartPos;
    protected int myEndPos;
    protected int myAnchor;
    protected QvtCodeReader myReader = new QvtCodeReader();

    public QvtPairMatcher(char[] pairs) {
        this.myPairs = pairs;
    }

    public IRegion match(IDocument document, int offset) {
        this.myOffset = offset;
        if (this.myOffset < 0) {
            return null;
        }
        this.myDocument = document;
        if (this.myDocument != null && this.matchPairsAt() && this.myStartPos != this.myEndPos) {
            return new Region(this.myStartPos, this.myEndPos - this.myStartPos + 1);
        }
        return null;
    }

    public int getAnchor() {
        return this.myAnchor;
    }

    public void dispose() {
        this.clear();
        this.myDocument = null;
        this.myReader = null;
    }

    public void clear() {
        if (this.myReader != null) {
            this.myReader.close();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean matchPairsAt() {
        int pairIndex1 = this.myPairs.length;
        int pairIndex2 = this.myPairs.length;
        this.myStartPos = -1;
        this.myEndPos = -1;
        try {
            char prevChar = this.myDocument.getChar(Math.max(this.myOffset - 1, 0));
            int i = 0;
            while (i < this.myPairs.length) {
                if (prevChar == this.myPairs[i]) {
                    this.myStartPos = this.myOffset - 1;
                    pairIndex1 = i;
                }
                i += 2;
            }
            i = 1;
            while (i < this.myPairs.length) {
                if (prevChar == this.myPairs[i]) {
                    this.myEndPos = this.myOffset - 1;
                    pairIndex2 = i;
                }
                i += 2;
            }
            if (this.myEndPos > -1) {
                this.myAnchor = 0;
                this.myStartPos = this.searchForOpeningPeer(this.myEndPos, this.myPairs[pairIndex2 - 1], this.myPairs[pairIndex2], this.myDocument);
                if (this.myStartPos > -1) {
                    return true;
                }
                this.myEndPos = -1;
                return false;
            }
            if (this.myStartPos <= -1) return false;
            this.myAnchor = 1;
            this.myEndPos = this.searchForClosingPeer(this.myStartPos, this.myPairs[pairIndex1], this.myPairs[pairIndex1 + 1], this.myDocument);
            if (this.myEndPos > -1) {
                return true;
            }
            this.myStartPos = -1;
            return false;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
        catch (IOException iOException) {}
        return false;
    }

    protected int searchForClosingPeer(int offset, int openingPeer, int closingPeer, IDocument document) throws IOException {
        this.myReader.configureForwardReader(document, offset + 1, document.getLength(), true, true);
        int stack = 1;
        int c = this.myReader.read();
        while (c != -1) {
            if (c == openingPeer && c != closingPeer) {
                ++stack;
            } else if (c == closingPeer) {
                --stack;
            }
            if (stack == 0) {
                return this.myReader.getOffset();
            }
            c = this.myReader.read();
        }
        return -1;
    }

    protected int searchForOpeningPeer(int offset, int openingPeer, int closingPeer, IDocument document) throws IOException {
        this.myReader.configureBackwardReader(document, offset, true, true);
        int stack = 1;
        int c = this.myReader.read();
        while (c != -1) {
            if (c == closingPeer && c != openingPeer) {
                ++stack;
            } else if (c == openingPeer) {
                --stack;
            }
            if (stack == 0) {
                return this.myReader.getOffset();
            }
            c = this.myReader.read();
        }
        return -1;
    }
}

