/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.debug.core;

import java.util.Arrays;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.m2m.atl.adt.debug.AtlDebugPlugin;
import org.eclipse.m2m.atl.adt.debug.core.AtlDebugElement;
import org.eclipse.m2m.atl.adt.debug.core.AtlDebugTarget;
import org.eclipse.m2m.atl.adt.debug.core.AtlStackFrame;

public class AtlThread
extends AtlDebugElement
implements IThread {
    private String threadName;
    private AtlDebugTarget atlDT;
    private AtlStackFrame[] stackFrames;

    public AtlThread(String name, AtlDebugTarget atlDT) {
        super(atlDT);
        this.threadName = name;
        this.atlDT = atlDT;
        this.stackFrames = null;
    }

    public IStackFrame[] getStackFrames() throws DebugException {
        if (!this.isSuspended()) {
            return new IStackFrame[0];
        }
        return this.stackFrames;
    }

    public boolean hasStackFrames() throws DebugException {
        if (!this.isSuspended()) {
            return false;
        }
        return this.getStackFrames() != null && this.getStackFrames().length > 0;
    }

    public int getPriority() throws DebugException {
        return 0;
    }

    public IStackFrame getTopStackFrame() throws DebugException {
        if (this.hasStackFrames()) {
            return this.getStackFrames()[0];
        }
        return null;
    }

    public String getName() throws DebugException {
        return this.threadName;
    }

    public IBreakpoint[] getBreakpoints() {
        String modelId = this.getModelIdentifier();
        return DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(modelId);
    }

    public String getModelIdentifier() {
        return AtlDebugPlugin.getUniqueIdentifier();
    }

    public IDebugTarget getDebugTarget() {
        return this.atlDT;
    }

    public ILaunch getLaunch() {
        return this.atlDT.getLaunch();
    }

    public boolean canResume() {
        return this.atlDT.canResume();
    }

    public boolean canSuspend() {
        return this.atlDT.canSuspend();
    }

    public boolean isSuspended() {
        return this.atlDT.isSuspended();
    }

    public void resume() throws DebugException {
        this.atlDT.resume();
    }

    public void suspend() throws DebugException {
        this.atlDT.suspend();
    }

    public boolean canStepInto() {
        return this.atlDT.isSuspended();
    }

    public boolean canStepOver() {
        return this.atlDT.isSuspended();
    }

    public boolean canStepReturn() {
        return this.atlDT.isSuspended();
    }

    public boolean isStepping() {
        return false;
    }

    public void stepInto() throws DebugException {
        if (this.canStepInto()) {
            this.atlDT.setState(1);
            this.atlDT.generateDebugEvent(4, this);
            this.atlDT.getDebugger().sendCommand(1, Arrays.asList(new Object[0]));
        }
    }

    public void stepOver() throws DebugException {
        if (this.canStepOver()) {
            this.atlDT.setState(1);
            this.atlDT.generateDebugEvent(3, this);
            this.atlDT.getDebugger().sendCommand(2, Arrays.asList(new Object[0]));
        }
    }

    public void stepReturn() throws DebugException {
        if (this.canStepReturn()) {
            this.atlDT.setPrevLocation(null);
            this.atlDT.setState(1);
            this.atlDT.generateDebugEvent(2, this);
            this.atlDT.getDebugger().sendCommand(3, Arrays.asList(new Object[0]));
        }
    }

    public boolean canTerminate() {
        return this.atlDT.canTerminate();
    }

    public boolean isTerminated() {
        return this.atlDT.isTerminated();
    }

    public void terminate() throws DebugException {
        this.atlDT.terminate();
    }

    public void setStackFrames(AtlStackFrame[] frames) {
        this.stackFrames = frames;
    }
}

