/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.symbols;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.BoldStylerProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServers;
import org.eclipse.lsp4e.outline.SymbolsLabelProvider;
import org.eclipse.lsp4e.ui.Messages;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.SymbolTag;
import org.eclipse.lsp4j.WorkspaceSymbol;
import org.eclipse.lsp4j.WorkspaceSymbolParams;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;

public class LSPSymbolInWorkspaceDialog
extends FilteredItemsSelectionDialog {
    private static final String DIALOG_SETTINGS = LSPSymbolInWorkspaceDialog.class.getName();
    private final InternalSymbolsLabelProvider labelProvider;
    private final IProject project;
    private @Nullable List<CompletableFuture<@Nullable Either<List<? extends SymbolInformation>, List<? extends WorkspaceSymbol>>>> request;

    public LSPSymbolInWorkspaceDialog(Shell shell, IProject project, BoldStylerProvider stylerProvider) {
        super(shell);
        this.project = project;
        this.labelProvider = new InternalSymbolsLabelProvider(stylerProvider);
        this.setMessage(Messages.LSPSymbolInWorkspaceDialog_DialogLabel);
        this.setTitle(Messages.LSPSymbolInWorkspaceDialog_DialogTitle);
        this.setListLabelProvider((ILabelProvider)this.labelProvider);
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        InternalItemsFilter itemsFilter = new InternalItemsFilter();
        this.labelProvider.setPattern(itemsFilter.getPattern());
        return itemsFilter;
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor monitor) throws CoreException {
        if (this.request != null) {
            this.request.forEach(f -> {
                boolean bl = f.cancel(true);
            });
        }
        if (itemsFilter.getPattern().isEmpty()) {
            return;
        }
        WorkspaceSymbolParams params = new WorkspaceSymbolParams(itemsFilter.getPattern());
        this.request = ((LanguageServers.LanguageServerProjectExecutor)LanguageServers.forProject(this.project).withCapability(ServerCapabilities::getWorkspaceSymbolProvider)).computeAll((w, ls) -> ls.getWorkspaceService().symbol(params));
        this.request.stream().map(f -> f.thenApply(LSPSymbolInWorkspaceDialog::eitherToWorkspaceSymbols)).forEach(cf -> {
            if (monitor.isCanceled()) {
                return;
            }
            try {
                for (Object item : (List)cf.get(1L, TimeUnit.SECONDS)) {
                    contentProvider.add(item, itemsFilter);
                }
            }
            catch (ExecutionException e) {
                LanguageServerPlugin.logError(e);
            }
            catch (InterruptedException e) {
                LanguageServerPlugin.logError(e);
                Thread.currentThread().interrupt();
            }
            catch (TimeoutException e) {
                LanguageServerPlugin.logWarning("Could not get workspace symbols due to timeout after 1 seconds in `workspace/symbol`", e);
            }
        });
    }

    public String getElementName(Object item) {
        return ((WorkspaceSymbol)item).getName();
    }

    protected Comparator<WorkspaceSymbol> getItemsComparator() {
        return (o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName());
    }

    protected IStatus validateItem(Object item) {
        return Status.OK_STATUS;
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = LanguageServerPlugin.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS);
        if (settings == null) {
            settings = LanguageServerPlugin.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS);
        }
        return settings;
    }

    protected @Nullable Control createExtendedContentArea(Composite parent) {
        return null;
    }

    private static List<WorkspaceSymbol> toWorkspaceSymbols(@Nullable List<? extends SymbolInformation> source) {
        return source == null ? List.of() : source.stream().map(LSPSymbolInWorkspaceDialog::toWorkspaceSymbol).filter(Objects::nonNull).toList();
    }

    private static @Nullable WorkspaceSymbol toWorkspaceSymbol(@Nullable SymbolInformation symbolinformation) {
        ArrayList<SymbolTag> tags;
        if (symbolinformation == null) {
            return null;
        }
        WorkspaceSymbol res = new WorkspaceSymbol();
        res.setName(symbolinformation.getName());
        res.setLocation(Either.forLeft((Object)symbolinformation.getLocation()));
        res.setKind(symbolinformation.getKind());
        res.setContainerName(symbolinformation.getContainerName());
        ArrayList<Object> arrayList = tags = symbolinformation.getTags() != null ? new ArrayList<SymbolTag>(symbolinformation.getTags()) : new ArrayList(1);
        if (symbolinformation.getDeprecated() != null && symbolinformation.getDeprecated().booleanValue()) {
            tags.add(SymbolTag.Deprecated);
        }
        res.setTags(tags);
        return res;
    }

    static List<? extends WorkspaceSymbol> eitherToWorkspaceSymbols(@Nullable Either<List<? extends SymbolInformation>, List<@Nullable ? extends WorkspaceSymbol>> source) {
        return source == null ? List.of() : (List)source.map(LSPSymbolInWorkspaceDialog::toWorkspaceSymbols, Function.identity());
    }

    private final class InternalItemsFilter
    extends FilteredItemsSelectionDialog.ItemsFilter {
        private InternalItemsFilter() {
            super((FilteredItemsSelectionDialog)LSPSymbolInWorkspaceDialog.this);
        }

        public boolean matchItem(@Nullable Object item) {
            return true;
        }

        public boolean isConsistentItem(@Nullable Object item) {
            return true;
        }

        public boolean isSubFilter(// Could not load outer class - annotation placement on inner may be incorrect
        @Nullable FilteredItemsSelectionDialog.ItemsFilter filter) {
            return false;
        }
    }

    private static final class InternalSymbolsLabelProvider
    extends SymbolsLabelProvider {
        private @Nullable String pattern;
        private final BoldStylerProvider stylerProvider;

        public InternalSymbolsLabelProvider(BoldStylerProvider stylerProvider) {
            super(true, InstanceScope.INSTANCE.getNode("org.eclipse.lsp4e").getBoolean("org.eclipse.lsp4e.outline.showKind", false));
            this.stylerProvider = stylerProvider;
        }

        @Override
        public StyledString getStyledText(@Nullable Object element) {
            int index;
            StyledString styledString = super.getStyledText(element);
            String pattern = this.pattern;
            if (pattern != null && (index = styledString.getString().toLowerCase().indexOf(pattern)) != -1) {
                styledString.setStyle(index, pattern.length(), this.stylerProvider.getBoldStyler());
            }
            return styledString;
        }

        @Override
        protected int getMaxSeverity(IResource resource, IDocument doc, Range range) throws CoreException, BadLocationException {
            int maxSeverity = -1;
            IMarker[] iMarkerArray = resource.findMarkers("org.eclipse.core.resources.problemmarker", true, 0);
            int n = iMarkerArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                int offset = marker.getAttribute("charStart", -1);
                if (offset != -1) {
                    maxSeverity = Math.max(maxSeverity, marker.getAttribute("severity", -1));
                }
                ++n2;
            }
            return maxSeverity;
        }

        public void setPattern(@Nullable String pattern) {
            this.pattern = pattern;
        }
    }
}

