/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.kafka.consumer;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.common.serialization.Deserializer;
import org.eclipse.hono.client.kafka.AbstractKafkaConfigProperties;
import org.eclipse.hono.client.kafka.CommonKafkaClientConfigProperties;
import org.eclipse.hono.client.kafka.CommonKafkaClientOptions;
import org.eclipse.hono.client.kafka.ConfigOptionsHelper;
import org.eclipse.hono.client.kafka.consumer.KafkaConsumerOptions;

public class KafkaConsumerConfigProperties
extends AbstractKafkaConfigProperties {
    public static final long DEFAULT_POLL_TIMEOUT_MILLIS = 250L;
    private final Class<? extends Deserializer<?>> keyDeserializerClass;
    private final Class<? extends Deserializer<?>> valueDeserializerClass;
    private long pollTimeout = 250L;

    protected KafkaConsumerConfigProperties(Class<? extends Deserializer<?>> keyDeserializerClass, Class<? extends Deserializer<?>> valueDeserializerClass) {
        this.keyDeserializerClass = Objects.requireNonNull(keyDeserializerClass);
        this.valueDeserializerClass = Objects.requireNonNull(valueDeserializerClass);
    }

    protected KafkaConsumerConfigProperties(Class<? extends Deserializer<?>> keyDeserializerClass, Class<? extends Deserializer<?>> valueDeserializerClass, CommonKafkaClientOptions commonOptions, KafkaConsumerOptions options) {
        this(keyDeserializerClass, valueDeserializerClass);
        Objects.requireNonNull(commonOptions);
        Objects.requireNonNull(options);
        CommonKafkaClientConfigProperties commonConfig = new CommonKafkaClientConfigProperties(commonOptions);
        this.setCommonClientConfig(commonConfig);
        this.setSpecificClientConfig(ConfigOptionsHelper.toStringValueMap(options.consumerConfig()));
        options.pollTimeout().ifPresent(this::setPollTimeout);
    }

    public final void setConsumerConfig(Map<String, String> consumerConfig) {
        this.setSpecificClientConfig(consumerConfig);
    }

    public final Map<String, String> getConsumerConfig(String consumerName) {
        Map<String, String> config = this.getConfig(consumerName);
        this.adaptConfiguration(config);
        Optional.ofNullable(this.keyDeserializerClass).ifPresent(serializerClass -> this.overrideConfigProperty(config, "key.deserializer", serializerClass.getName()));
        Optional.ofNullable(this.valueDeserializerClass).ifPresent(serializerClass -> this.overrideConfigProperty(config, "value.deserializer", serializerClass.getName()));
        return config;
    }

    protected void adaptConfiguration(Map<String, String> config) {
    }

    public final void setPollTimeout(long pollTimeoutMillis) {
        if (pollTimeoutMillis < 0L) {
            throw new IllegalArgumentException("poll timeout must not be negative");
        }
        this.pollTimeout = pollTimeoutMillis;
    }

    public final long getPollTimeout() {
        return this.pollTimeout;
    }
}

