/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.virtual.threads;

import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.virtual.threads.ContextPreservingExecutorService;
import io.quarkus.virtual.threads.DelegatingExecutorService;
import io.quarkus.virtual.threads.FallbackVirtualThreadsExecutorService;
import io.quarkus.virtual.threads.VirtualThreadsConfig;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

@Recorder
public class VirtualThreadsRecorder {
    private static final Logger logger = Logger.getLogger("io.quarkus.virtual-threads");
    static VirtualThreadsConfig config = new VirtualThreadsConfig();
    private static volatile ExecutorService current;
    private static final Object lock;
    public static Supplier<ExecutorService> VIRTUAL_THREADS_EXECUTOR_SUPPLIER;

    public void setupVirtualThreads(VirtualThreadsConfig c, ShutdownContext shutdownContext, LaunchMode launchMode) {
        config = c;
        if (VirtualThreadsRecorder.config.enabled) {
            if (launchMode == LaunchMode.DEVELOPMENT) {
                shutdownContext.addLastShutdownTask(new Runnable(){

                    @Override
                    public void run() {
                        ExecutorService service = current;
                        if (service != null) {
                            service.shutdownNow();
                        }
                        current = null;
                    }
                });
            } else {
                shutdownContext.addLastShutdownTask(new Runnable(){

                    @Override
                    public void run() {
                        ExecutorService service = current;
                        current = null;
                        if (service != null) {
                            service.shutdown();
                            long timeout = VirtualThreadsRecorder.config.shutdownTimeout.toNanos();
                            long interval = VirtualThreadsRecorder.config.shutdownCheckInterval.orElse(VirtualThreadsRecorder.config.shutdownTimeout).toNanos();
                            long start = System.nanoTime();
                            int loop = 1;
                            long elapsed = 0L;
                            while (true) {
                                logger.debugf("Await termination loop: %s, remaining: %s", (long)loop++, timeout - elapsed);
                                try {
                                    if (!service.awaitTermination(Math.min(timeout, interval), TimeUnit.NANOSECONDS)) {
                                        elapsed = System.nanoTime() - start;
                                        if (elapsed < timeout) continue;
                                    } else {
                                        return;
                                    }
                                    service.shutdownNow();
                                }
                                catch (InterruptedException interruptedException) {
                                    continue;
                                }
                                break;
                            }
                        }
                    }
                });
            }
        }
    }

    public Supplier<ExecutorService> getCurrentSupplier() {
        return VIRTUAL_THREADS_EXECUTOR_SUPPLIER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExecutorService getCurrent() {
        ExecutorService executor = current;
        if (executor != null) {
            return executor;
        }
        Object object = lock;
        synchronized (object) {
            if (current == null) {
                current = VirtualThreadsRecorder.createExecutor();
            }
            return current;
        }
    }

    static ExecutorService newVirtualThreadPerTaskExecutorWithName(String prefix) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, ClassNotFoundException {
        Method ofVirtual = Thread.class.getMethod("ofVirtual", new Class[0]);
        Object vtb = ofVirtual.invoke(VirtualThreadsRecorder.class, new Object[0]);
        Class<?> vtbClass = Class.forName("java.lang.Thread$Builder$OfVirtual");
        if (prefix != null) {
            Method name = vtbClass.getMethod("name", String.class, Long.TYPE);
            vtb = name.invoke(vtb, prefix, 0);
        }
        Method uncaughtHandler = vtbClass.getMethod("uncaughtExceptionHandler", Thread.UncaughtExceptionHandler.class);
        vtb = uncaughtHandler.invoke(vtb, new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                logger.errorf(e, "Thread %s threw an uncaught exception:", (Object)t);
            }
        });
        Method factory = vtbClass.getMethod("factory", new Class[0]);
        ThreadFactory tf = (ThreadFactory)factory.invoke(vtb, new Object[0]);
        return (ExecutorService)Executors.class.getMethod("newThreadPerTaskExecutor", ThreadFactory.class).invoke(VirtualThreadsRecorder.class, tf);
    }

    private static ExecutorService createExecutor() {
        if (VirtualThreadsRecorder.config.enabled) {
            try {
                String prefix = VirtualThreadsRecorder.config.namePrefix.orElse(null);
                return new ContextPreservingExecutorService(VirtualThreadsRecorder.newVirtualThreadPerTaskExecutorWithName(prefix));
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                logger.debug((Object)"Unable to invoke java.util.concurrent.Executors#newVirtualThreadPerTaskExecutor", e);
                logger.warn("You weren't able to create an executor that spawns virtual threads, the default blocking executor will be used, please check that your JDK is compatible with virtual threads");
            }
        }
        return new FallbackVirtualThreadsExecutorService();
    }

    static {
        lock = new Object();
        VIRTUAL_THREADS_EXECUTOR_SUPPLIER = new Supplier<ExecutorService>(){

            @Override
            public ExecutorService get() {
                return new DelegatingExecutorService(VirtualThreadsRecorder.getCurrent());
            }
        };
    }
}

