/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.iterator;

import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.iterator.QueryIteratorBase;
import org.apache.jena.sparql.serializer.SerializationContext;

public class QueryIteratorWrapper
extends QueryIteratorBase {
    protected QueryIterator iterator;

    public QueryIteratorWrapper(QueryIterator qIter) {
        this.iterator = qIter;
    }

    @Override
    protected boolean hasNextBinding() {
        return this.iterator.hasNext();
    }

    @Override
    protected Binding moveToNextBinding() {
        return this.iterator.nextBinding();
    }

    @Override
    protected void closeIterator() {
        if (this.iterator != null) {
            this.iterator.close();
            this.iterator = null;
        }
    }

    @Override
    protected void requestCancel() {
        if (this.iterator != null) {
            this.iterator.cancel();
        }
    }

    @Override
    public void output(IndentedWriter out) {
        this.iterator.output(out);
    }

    @Override
    public void output(IndentedWriter out, SerializationContext sCxt) {
        out.println(Lib.className(this) + "/" + Lib.className(this.iterator));
        out.incIndent();
        this.iterator.output(out, sCxt);
        out.decIndent();
    }
}

