/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shex.expressions;

import java.util.List;
import java.util.Objects;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.out.NodeFormatter;
import org.apache.jena.shex.expressions.ShapeExprVisitor;
import org.apache.jena.shex.expressions.ShapeExpression;
import org.apache.jena.shex.sys.ReportItem;
import org.apache.jena.shex.sys.ValidationContext;

public class ShapeExprOR
extends ShapeExpression {
    private List<ShapeExpression> shapeExpressions;

    public static ShapeExpression create(List<ShapeExpression> acc) {
        if (acc.size() == 0) {
            throw new InternalErrorException("Empty list");
        }
        if (acc.size() == 1) {
            return acc.get(0);
        }
        return new ShapeExprOR(acc);
    }

    private ShapeExprOR(List<ShapeExpression> expressions) {
        this.shapeExpressions = expressions;
    }

    public List<ShapeExpression> expressions() {
        return this.shapeExpressions;
    }

    @Override
    public boolean satisfies(ValidationContext vCxt, Node data) {
        for (ShapeExpression shExpr : this.shapeExpressions) {
            ValidationContext vCxt2;
            boolean innerSatisfies = shExpr.satisfies(vCxt2 = vCxt.create(), data);
            if (!innerSatisfies) continue;
            return true;
        }
        ReportItem item = new ReportItem("OR expression not satisfied:", data);
        vCxt.reportEntry(item);
        return false;
    }

    @Override
    public void visit(ShapeExprVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void print(IndentedWriter out, NodeFormatter nFmt) {
        out.println("OR");
        int idx = 0;
        for (ShapeExpression shExpr : this.shapeExpressions) {
            out.printf("%d -", ++idx);
            out.incIndent(4);
            shExpr.print(out, nFmt);
            out.decIndent(4);
        }
        out.println("/OR");
    }

    @Override
    public String toString() {
        return "ShapeExprOr " + this.expressions();
    }

    @Override
    public int hashCode() {
        return Objects.hash(2, this.shapeExpressions);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ShapeExprOR other = (ShapeExprOR)obj;
        return Objects.equals(this.shapeExpressions, other.shapeExpressions);
    }
}

