/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfs.setup;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.Syntax;
import org.apache.jena.rdfs.engine.ConstRDFS;
import org.apache.jena.rdfs.setup.ConfigRDFS;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.system.G;
import org.apache.jena.system.Transitive;

public abstract class BaseSetupRDFS<X>
implements ConfigRDFS<X> {
    public final Graph vocabGraph;
    private final Map<X, Set<X>> superClasses = new HashMap<X, Set<X>>();
    private final Map<X, Set<X>> superClassesInc = new HashMap<X, Set<X>>();
    private final Map<X, Set<X>> subClasses = new HashMap<X, Set<X>>();
    private final Map<X, Set<X>> subClassesInc = new HashMap<X, Set<X>>();
    private final Map<X, Set<X>> superPropertiesInc = new HashMap<X, Set<X>>();
    private final Map<X, Set<X>> superProperties = new HashMap<X, Set<X>>();
    private final Map<X, Set<X>> subPropertiesInc = new HashMap<X, Set<X>>();
    private final Map<X, Set<X>> subProperties = new HashMap<X, Set<X>>();
    private final Map<X, Set<X>> propertyRange = new HashMap<X, Set<X>>();
    private final Map<X, Set<X>> propertyDomain = new HashMap<X, Set<X>>();
    private final Map<X, Set<X>> rangeToProperty = new HashMap<X, Set<X>>();
    private final Map<X, Set<X>> domainToProperty = new HashMap<X, Set<X>>();
    private final boolean hasAnyRDFS;
    private final boolean hasOnlyPropertyDeclarations;
    private static String preamble = StrUtils.strjoinNL("PREFIX  rdf:    <http://www.w3.org/1999/02/22-rdf-syntax-ns#>", "PREFIX  rdfs:   <http://www.w3.org/2000/01/rdf-schema#>", "PREFIX  xsd:    <http://www.w3.org/2001/XMLSchema#>", "PREFIX  owl:    <http://www.w3.org/2002/07/owl#>", "PREFIX skos:    <http://www.w3.org/2004/02/skos/core#>");

    protected BaseSetupRDFS(Graph vocab) {
        this.vocabGraph = vocab;
        this.hasAnyRDFS = this.setup();
        this.hasOnlyPropertyDeclarations = !this.hasClassDeclarations() && !this.hasDomainDeclarations() && !this.hasRangeDeclarations();
    }

    private boolean setup() {
        boolean CHECK = false;
        this.execTransitive(this.vocabGraph, ConstRDFS.rdfsSubClassOf, this.superClasses, this.subClasses);
        this.execTransitive(this.vocabGraph, ConstRDFS.rdfsSubPropertyOf, this.superProperties, this.subProperties);
        this.execSingle(this.vocabGraph, ConstRDFS.rdfsDomain, this.propertyDomain, this.domainToProperty);
        this.execSingle(this.vocabGraph, ConstRDFS.rdfsRange, this.propertyRange, this.rangeToProperty);
        this.deepCopyInto(this.superClassesInc, this.superClasses);
        this.addKeysToValues(this.superClassesInc);
        this.deepCopyInto(this.subClassesInc, this.subClasses);
        this.addKeysToValues(this.subClassesInc);
        this.deepCopyInto(this.superPropertiesInc, this.superProperties);
        this.addKeysToValues(this.superPropertiesInc);
        this.deepCopyInto(this.subPropertiesInc, this.subProperties);
        this.addKeysToValues(this.subPropertiesInc);
        return this.hasClassDeclarations() || this.hasPropertyDeclarations() || this.hasRangeDeclarations() || this.hasDomainDeclarations();
    }

    protected abstract X fromNode(Node var1);

    @Override
    public Map<X, Set<X>> getSubClassHierarchy() {
        return this.superClassesInc;
    }

    @Override
    public Map<X, Set<X>> getSubPropertyHierarchy() {
        return this.superPropertiesInc;
    }

    @Override
    public Map<X, Set<X>> getPropertyRanges() {
        return this.propertyRange;
    }

    @Override
    public Map<X, Set<X>> getPropertyDomains() {
        return this.propertyDomain;
    }

    @Override
    public Set<X> getSuperClasses(X elt) {
        return this.result(this.superClasses, elt);
    }

    @Override
    public Set<X> getSuperClassesInc(X elt) {
        return this.result(this.superClassesInc, elt);
    }

    @Override
    public Set<X> getSubClasses(X elt) {
        return this.result(this.subClasses, elt);
    }

    @Override
    public Set<X> getSubClassesInc(X elt) {
        return this.result(this.subClassesInc, elt);
    }

    @Override
    public Set<X> getSuperProperties(X elt) {
        return this.result(this.superProperties, elt);
    }

    @Override
    public Set<X> getSuperPropertiesInc(X elt) {
        return this.result(this.superPropertiesInc, elt);
    }

    @Override
    public Set<X> getSubProperties(X elt) {
        return this.result(this.subProperties, elt);
    }

    @Override
    public Set<X> getSubPropertiesInc(X elt) {
        return this.result(this.subPropertiesInc, elt);
    }

    @Override
    public boolean hasClassDeclarations() {
        return !this.subClasses.isEmpty();
    }

    @Override
    public boolean hasPropertyDeclarations() {
        return !this.subProperties.isEmpty();
    }

    @Override
    public boolean hasRangeDeclarations() {
        return !this.propertyRange.isEmpty();
    }

    @Override
    public boolean hasDomainDeclarations() {
        return !this.propertyDomain.isEmpty();
    }

    @Override
    public boolean hasOnlyPropertyDeclarations() {
        return this.hasOnlyPropertyDeclarations;
    }

    @Override
    public boolean hasRDFS() {
        return this.hasAnyRDFS;
    }

    @Override
    public Set<X> getRange(X elt) {
        return this.result(this.propertyRange, elt);
    }

    @Override
    public Set<X> getDomain(X elt) {
        return this.result(this.propertyDomain, elt);
    }

    @Override
    public Set<X> getPropertiesByRange(X elt) {
        return this.result(this.rangeToProperty, elt);
    }

    @Override
    public Set<X> getPropertiesByDomain(X elt) {
        return this.result(this.domainToProperty, elt);
    }

    private void execCheck(String path, Graph vocab, Map<X, Set<X>> supers, Map<X, Set<X>> subs) {
        HashMap mSupers = new HashMap();
        HashMap mSubs = new HashMap();
        String queryString = "SELECT ?x ?y { ?x " + path + " ?y }";
        this.exec(queryString, vocab, mSupers, mSubs);
        if (!mSupers.equals(supers) || !mSubs.equals(subs)) {
            throw new InternalErrorException(path);
        }
    }

    private void execTransitive(Graph vocab, Node property, Map<X, Set<X>> superMap, Map<X, Set<X>> subMap) {
        Map<Node, Collection<Node>> map = Transitive.transitive(vocab, property);
        map.forEach((n, c) -> c.forEach(nc -> {
            X a = this.fromNode((Node)n);
            X b = this.fromNode((Node)nc);
            BaseSetupRDFS.put(superMap, a, b);
            BaseSetupRDFS.put(subMap, b, a);
        }));
    }

    private void execSingle(Graph vocab, Node predicate, Map<X, Set<X>> propertyMap, Map<X, Set<X>> reversePropertyMap) {
        G.find(vocab, Node.ANY, predicate, Node.ANY).forEach(t -> {
            Node s = t.getSubject();
            Node o = t.getObject();
            X a = this.fromNode(s);
            X b = this.fromNode(o);
            BaseSetupRDFS.put(propertyMap, a, b);
            BaseSetupRDFS.put(reversePropertyMap, b, a);
        });
    }

    private void deepCopyInto(Map<X, Set<X>> dest, Map<X, Set<X>> src) {
        src.entrySet().forEach(e2 -> {
            HashSet x = new HashSet((Collection)e2.getValue());
            dest.put(e2.getKey(), x);
        });
    }

    private void addKeysToValues(Map<X, Set<X>> map) {
        map.entrySet().forEach(e2 -> ((Set)e2.getValue()).add(e2.getKey()));
        this.ensureValuesAsKeys(map);
    }

    private void ensureValuesAsKeys(Map<X, Set<X>> map) {
        Set<Object> free = map.values().stream().flatMap(setx -> setx.stream()).filter(x -> !map.containsKey(x)).collect(Collectors.toSet());
        free.forEach(x -> {
            HashSet<Object> set = (HashSet<Object>)map.get(x);
            if (set == null) {
                set = new HashSet<Object>();
                map.put(x, set);
            }
            set.add(x);
        });
    }

    private void exec(String qs, Graph graph, Map<X, Set<X>> multimap1, Map<X, Set<X>> multimap2) {
        Query query = QueryFactory.create(preamble + "\n" + qs, Syntax.syntaxARQ);
        try (QueryExecution qexec = QueryExecutionFactory.create(query, DatasetGraphFactory.wrap(graph));){
            ResultSet rs = qexec.execSelect();
            while (rs.hasNext()) {
                Binding soln = rs.nextBinding();
                Node x = soln.get(Var.alloc("x"));
                Node y = soln.get(Var.alloc("y"));
                X a = this.fromNode(x);
                X b = this.fromNode(y);
                BaseSetupRDFS.put(multimap1, a, b);
                BaseSetupRDFS.put(multimap2, b, a);
            }
        }
    }

    private static <X> void put(Map<X, Set<X>> multimap, X n1, X n2) {
        if (!multimap.containsKey(n1)) {
            multimap.put(n1, new HashSet());
        }
        multimap.get(n1).add(n2);
    }

    private Set<X> result(Map<X, Set<X>> map, X elt) {
        Set<X> x = map.get(elt);
        return x != null ? x : Collections.emptySet();
    }
}

