/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontapi.model;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.ontapi.OntJenaException;
import org.apache.jena.ontapi.model.OntAnnotation;
import org.apache.jena.ontapi.model.OntAnnotationProperty;
import org.apache.jena.ontapi.model.OntModel;
import org.apache.jena.ontapi.model.OntObject;
import org.apache.jena.ontapi.utils.StdModels;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.vocabulary.RDF;

public interface OntStatement
extends Statement {
    @Override
    public OntModel getModel();

    public OntStatement addAnnotation(OntAnnotationProperty var1, RDFNode var2);

    public Stream<OntStatement> annotations();

    public OntStatement deleteAnnotation(OntAnnotationProperty var1, RDFNode var2) throws OntJenaException;

    public Stream<OntAnnotation> annotationResources();

    @Override
    public OntObject getSubject();

    default public boolean isLocal() {
        return this.getModel().getBaseGraph().contains(this.asTriple());
    }

    default public List<OntAnnotation> getAnnotationList() {
        return this.annotationResources().sorted(StdModels.RDF_NODE_COMPARATOR).collect(Collectors.toList());
    }

    default public Optional<OntAnnotation> asAnnotationResource() {
        List<OntAnnotation> res = this.getAnnotationList();
        return res.isEmpty() ? Optional.empty() : Optional.of(res.get(0));
    }

    default public Stream<OntStatement> annotations(OntAnnotationProperty property) {
        return this.annotations().filter(s -> Objects.equals(property, s.getPredicate()));
    }

    default public OntStatement deleteAnnotation(OntAnnotationProperty property) {
        this.annotations(property).map(Statement::getObject).collect(Collectors.toSet()).forEach(v -> this.deleteAnnotation(property, (RDFNode)v));
        return this;
    }

    default public boolean isDeclaration() {
        return RDF.type.equals(this.getPredicate());
    }

    default public boolean belongsToAnnotation() {
        return this.getSubject().canAs(OntAnnotation.class);
    }

    default public boolean isAnnotationAssertion() {
        return this.getPredicate().canAs(OntAnnotationProperty.class);
    }

    default public OntStatement clearAnnotations() {
        this.annotations().peek(OntStatement::clearAnnotations).collect(Collectors.toSet()).forEach(a -> this.deleteAnnotation(a.getPredicate().as(OntAnnotationProperty.class), a.getObject()));
        return this;
    }

    default public boolean hasAnnotations() {
        try (Stream<OntStatement> annotations = this.annotations();){
            boolean bl = annotations.findFirst().isPresent();
            return bl;
        }
    }

    default public OntStatement addAnnotation(OntAnnotationProperty predicate, String text) {
        return this.addAnnotation(predicate, text, null);
    }

    default public OntStatement addAnnotation(OntAnnotationProperty predicate, String text, String lang) {
        return this.addAnnotation(predicate, this.getModel().createLiteral(text, lang));
    }

    default public OntStatement annotate(OntAnnotationProperty property, String text) {
        return this.annotate(property, text, null);
    }

    default public OntStatement annotate(OntAnnotationProperty property, String text, String lang) {
        return this.annotate(property, this.getModel().createLiteral(text, lang));
    }

    default public OntStatement annotate(OntAnnotationProperty property, RDFNode value) {
        this.addAnnotation(property, value);
        return this;
    }

    default public <S extends Resource> S getSubject(Class<S> type) {
        return (S)((Resource)this.getSubject().as(type));
    }

    default public <O extends RDFNode> O getObject(Class<O> type) {
        return this.getObject().as(type);
    }
}

