/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontapi.impl.objects;

import java.util.Optional;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.Node;
import org.apache.jena.ontapi.impl.OntGraphModelImpl;
import org.apache.jena.ontapi.impl.objects.OntObjectImpl;
import org.apache.jena.ontapi.model.OntDataProperty;
import org.apache.jena.ontapi.model.OntIndividual;
import org.apache.jena.ontapi.model.OntModel;
import org.apache.jena.ontapi.model.OntNegativeAssertion;
import org.apache.jena.ontapi.model.OntObjectProperty;
import org.apache.jena.ontapi.model.OntRelationalProperty;
import org.apache.jena.ontapi.model.OntStatement;
import org.apache.jena.ontapi.utils.Iterators;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.OWL2;
import org.apache.jena.vocabulary.RDF;

public abstract class OntNegativePropertyAssertionImpl<P extends OntRelationalProperty, T extends RDFNode>
extends OntObjectImpl
implements OntNegativeAssertion<P, T> {
    public OntNegativePropertyAssertionImpl(Node n, EnhGraph m) {
        super(n, m);
    }

    public static OntNegativeAssertion.WithDataProperty create(OntGraphModelImpl model, OntIndividual source, OntDataProperty property, Literal target) {
        Resource res = OntNegativePropertyAssertionImpl.create(model, source).addProperty(OWL2.assertionProperty, property).addProperty(OWL2.targetValue, target);
        return model.getNodeAs(res.asNode(), OntNegativeAssertion.WithDataProperty.class);
    }

    public static OntNegativeAssertion.WithObjectProperty create(OntGraphModelImpl model, OntIndividual source, OntObjectProperty property, OntIndividual target) {
        Resource res = OntNegativePropertyAssertionImpl.create(model, source).addProperty(OWL2.assertionProperty, property).addProperty(OWL2.targetIndividual, target);
        return model.getNodeAs(res.asNode(), OntNegativeAssertion.WithObjectProperty.class);
    }

    private static Resource create(OntModel model, OntIndividual source) {
        Resource res = model.createResource();
        res.addProperty(RDF.type, OWL2.NegativePropertyAssertion);
        res.addProperty(OWL2.sourceIndividual, source);
        return res;
    }

    @Override
    public Optional<OntStatement> findRootStatement() {
        return OntNegativePropertyAssertionImpl.getRequiredRootStatement(this, OWL2.NegativePropertyAssertion);
    }

    @Override
    public ExtendedIterator<OntStatement> listSpec() {
        return Iterators.concat(super.listSpec(), this.listRequired(OWL2.sourceIndividual, OWL2.assertionProperty, this.targetPredicate()));
    }

    abstract Class<P> propertyClass();

    abstract Property targetPredicate();

    @Override
    public OntIndividual getSource() {
        return this.getRequiredObject(OWL2.sourceIndividual, OntIndividual.class);
    }

    @Override
    public P getProperty() {
        return (P)((OntRelationalProperty)this.getRequiredObject(OWL2.assertionProperty, this.propertyClass()));
    }

    public static class DataAssertionImpl
    extends OntNegativePropertyAssertionImpl<OntDataProperty, Literal>
    implements OntNegativeAssertion.WithDataProperty {
        public DataAssertionImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        @Override
        Class<OntDataProperty> propertyClass() {
            return OntDataProperty.class;
        }

        @Override
        Property targetPredicate() {
            return OWL2.targetValue;
        }

        public Class<OntNegativeAssertion.WithDataProperty> objectType() {
            return OntNegativeAssertion.WithDataProperty.class;
        }

        @Override
        public Literal getTarget() {
            return this.getRequiredObject(this.targetPredicate(), Literal.class);
        }
    }

    public static class ObjectAssertionImpl
    extends OntNegativePropertyAssertionImpl<OntObjectProperty, OntIndividual>
    implements OntNegativeAssertion.WithObjectProperty {
        public ObjectAssertionImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        @Override
        Class<OntObjectProperty> propertyClass() {
            return OntObjectProperty.class;
        }

        @Override
        Property targetPredicate() {
            return OWL2.targetIndividual;
        }

        public Class<OntNegativeAssertion.WithObjectProperty> objectType() {
            return OntNegativeAssertion.WithObjectProperty.class;
        }

        @Override
        public OntIndividual getTarget() {
            return this.getRequiredObject(this.targetPredicate(), OntIndividual.class);
        }
    }
}

