/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.data;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.jena.atlas.data.SerializationFactory;
import org.apache.jena.atlas.data.SortedDataBag;
import org.apache.jena.atlas.data.ThresholdPolicy;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.iterator.PeekIterator;
import org.apache.jena.atlas.lib.Closeable;

public class DistinctDataBag<E>
extends SortedDataBag<E> {
    public DistinctDataBag(ThresholdPolicy<E> policy, SerializationFactory<E> serializerFactory, Comparator<E> comparator) {
        super(policy, serializerFactory, comparator);
        this.memory = new HashSet();
    }

    @Override
    public boolean isSorted() {
        return false;
    }

    @Override
    public boolean isDistinct() {
        return true;
    }

    @Override
    public Iterator<E> iterator() {
        if (!this.spilled) {
            this.checkClosed();
            this.finishedAdding = true;
            if (this.memory.size() > 0) {
                return this.memory.iterator();
            }
            return Iter.nullIterator();
        }
        return new DistinctReducedIterator(super.iterator());
    }

    protected static class DistinctReducedIterator<T>
    extends PeekIterator<T>
    implements Closeable {
        private Iterator<T> iter;

        public DistinctReducedIterator(Iterator<T> iter) {
            super(iter);
            this.iter = iter;
        }

        @Override
        public T next() {
            Object item = super.next();
            while (this.hasNext() && (null == item && null == this.peek() || null != item && item.equals(this.peek()))) {
                item = super.next();
            }
            return item;
        }

        @Override
        public void close() {
            Iter.close(this.iter);
        }
    }
}

