/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.fxgraph.ui.wizards;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.fx.ide.fxgraph.ui.wizards.FXGraphWizardPage;
import org.eclipse.fx.ide.fxgraph.ui.wizards.template.FXGraphElement;
import org.eclipse.fx.ide.fxgraph.ui.wizards.template.FXGraphTemplate;
import org.eclipse.fx.ide.ui.wizards.AbstractNewJDTElementWizard;
import org.eclipse.fx.ide.ui.wizards.template.IGenerator;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizardPage;

public class NewFXGraphWizard
extends AbstractNewJDTElementWizard<FXGraphElement> {
    private static final String SETTINGS_FILE = "new-graph-settings.xml";
    public static final String KEY_LAST_SELECTIONS = "KEY_LAST_SELECTIONS";
    private static final int MAX_HISTORY_SIZE = 20;

    public NewFXGraphWizard() {
        if (this.getDialogSettings() == null) {
            DialogSettings settings = new DialogSettings("new-fxgraph");
            try {
                settings.load(SETTINGS_FILE);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.setDialogSettings((IDialogSettings)settings);
        }
    }

    protected IGenerator<FXGraphElement> getGenerator() {
        return new FXGraphTemplate();
    }

    public void addPages() {
        this.addPage((IWizardPage)new FXGraphWizardPage(this.getInitialRoot(), this.getInitialFragment(), ResourcesPlugin.getWorkspace().getRoot()));
    }

    public boolean performFinish() {
        boolean finish = super.performFinish();
        if (finish && this.getDialogSettings() != null) {
            IDialogSettings settings = this.getDialogSettings();
            String typeName = ((FXGraphElement)this.getDomainClass()).getRootElement().getFullyQualifiedName();
            String[] elements = settings.getArray(KEY_LAST_SELECTIONS);
            if (elements == null) {
                settings.put(KEY_LAST_SELECTIONS, new String[]{typeName});
            } else {
                ArrayList<String> ar = new ArrayList<String>(Arrays.asList(elements));
                ar.remove(typeName);
                ar.add(0, typeName);
                if (ar.size() > 20) {
                    while (ar.size() > 20) {
                        ar.remove(20);
                    }
                }
                settings.put(KEY_LAST_SELECTIONS, ar.toArray(new String[0]));
            }
            try {
                settings.save(SETTINGS_FILE);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return finish;
    }

    protected IFile createFile() {
        if (this.getFragment() != null) {
            String fxgraph = ((FXGraphElement)this.getDomainClass()).getName() + ".fxgraph";
            IFolder p = (IFolder)this.getFragment().getResource();
            IFile resource = p.getFile(fxgraph);
            return resource;
        }
        String fxgraph = ((FXGraphElement)this.getDomainClass()).getName() + ".fxgraph";
        IFolder p = (IFolder)((FXGraphElement)this.getDomainClass()).getFragmentRoot().getResource();
        return p.getFile(fxgraph);
    }
}

