/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.media;

import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Optional;
import javafx.scene.media.AudioClip;
import javafx.scene.media.Media;
import org.eclipse.fx.core.Resource;
import org.eclipse.fx.core.Util;
import org.eclipse.jdt.annotation.NonNull;

public class MediaLoader {
    private static boolean isSupported(URL url) {
        if ("http".equals(url.getProtocol()) || "https".equals(url.getProtocol()) || "file".equals(url.getProtocol())) {
            return true;
        }
        if ("jar".equals(url.getProtocol())) {
            try {
                if ("file".equals(new URL(url.getFile()).getProtocol())) {
                    return true;
                }
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static Optional<Media> createMedia(@NonNull URL url) {
        if (MediaLoader.isSupported(url)) {
            return Optional.of(new Media(url.toExternalForm()));
        }
        Optional localURL = Util.getLocalURL((URL)url);
        if (localURL.isPresent() && MediaLoader.isSupported((URL)localURL.get())) {
            return Optional.of(new Media(((URL)localURL.get()).toExternalForm()));
        }
        @NonNull Optional localPath = Util.getLocalPath((URL)url, (boolean)false);
        if (localPath.isPresent()) {
            try {
                return Optional.of(new Media(((Path)((Resource)localPath.get()).getNativeResource()).toUri().toURL().toExternalForm()));
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        return Optional.empty();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static Optional<AudioClip> createAudioClip(@NonNull URL url) {
        if (MediaLoader.isSupported(url)) {
            return Optional.of(new AudioClip(url.toExternalForm()));
        }
        Optional localURL = Util.getLocalURL((URL)url);
        if (localURL.isPresent() && MediaLoader.isSupported((URL)localURL.get())) {
            return Optional.of(new AudioClip(((URL)localURL.get()).toExternalForm()));
        }
        @NonNull Optional localPath = Util.getLocalPath((URL)url, (boolean)false);
        if (localPath.isPresent()) {
            try {
                return Optional.of(new AudioClip(((Path)((Resource)localPath.get()).getNativeResource()).toUri().toURL().toExternalForm()));
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        return Optional.empty();
    }
}

