/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.text.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.beans.value.ChangeListener;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Parent;
import javafx.scene.control.Control;
import javafx.scene.layout.BorderPane;
import javafx.stage.PopupWindow;
import org.eclipse.fx.text.hover.DocumentHoverProvider;
import org.eclipse.fx.text.hover.HoverInfo;
import org.eclipse.fx.text.ui.TextViewer;
import org.eclipse.fx.text.ui.hover.HoverPresenter;
import org.eclipse.fx.text.ui.hover.internal.DefaultHoverPresenter;
import org.eclipse.fx.text.ui.hover.internal.DefaultHoverWindowPresenter;
import org.eclipse.fx.text.ui.hover.internal.HtmlHoverPresenter;
import org.eclipse.fx.ui.controls.styledtext.StyledTextArea;
import org.eclipse.fx.ui.controls.styledtext.events.HoverTarget;
import org.eclipse.fx.ui.controls.styledtext.events.TextHoverEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.Annotation;

public class TextViewerHoverManager {
    List<DocumentHoverProvider> providers = new ArrayList<DocumentHoverProvider>();
    DefaultHoverWindowPresenter windowPresenter;
    List<HoverPresenter> hoverPresenters = new ArrayList<HoverPresenter>();
    private final TextViewer textViewer;
    private final PopupWindow popup;
    private final BorderPane root;
    private final ChangeListener<Boolean> windowFocusListener = (x, o, n) -> {
        if (!n.booleanValue()) {
            this.windowPresenter.hide();
        }
    };

    public TextViewerHoverManager(TextViewer textViewer) {
        this.windowPresenter = new DefaultHoverWindowPresenter((Control)textViewer.getTextWidget());
        this.hoverPresenters.add(new DefaultHoverPresenter());
        this.hoverPresenters.add(new HtmlHoverPresenter());
        this.windowPresenter.setHoverPresenter(this.hoverPresenters);
        this.textViewer = textViewer;
        this.textViewer.sceneProperty().addListener((x, o, n) -> {
            if (o != null) {
                o.getWindow().focusedProperty().removeListener(this.windowFocusListener);
            }
            if (n != null) {
                n.getWindow().focusedProperty().addListener(this.windowFocusListener);
            }
        });
        if (this.textViewer.getScene() != null) {
            this.textViewer.getScene().getWindow().focusedProperty().addListener(this.windowFocusListener);
        }
        this.popup = new PopupWindow(){};
        this.popup.setAutoFix(false);
        this.popup.setAutoHide(false);
        this.textViewer.getTextWidget().sceneProperty().addListener(e -> {
            if (textViewer.getTextWidget().getScene() != null) {
                this.popup.getScene().getStylesheets().setAll((Collection)textViewer.getTextWidget().getScene().getStylesheets());
            }
        });
        this.root = new BorderPane();
        this.root.getStyleClass().add((Object)"styled-text-hover");
        this.popup.getScene().setRoot((Parent)this.root);
    }

    public TextViewer getTextViewer() {
        return this.textViewer;
    }

    public PopupWindow getPopup() {
        return this.popup;
    }

    public BorderPane getRoot() {
        return this.root;
    }

    public void doHovers(TextHoverEvent e) {
        if (e.getOffset() > 0) {
            IDocument document = this.getTextViewer().getDocument();
            ArrayList<HoverInfo> hovers = new ArrayList<HoverInfo>();
            hovers.addAll(this.getTextViewer().getHoverInfo(e.getOffset()));
            hovers.addAll(this.providers.stream().flatMap(p -> p.getHoverInfo(document, e.getOffset()).stream()).collect(Collectors.toSet()));
            Set annotationTargets = e.getHoverTargets().stream().filter(t -> t.model instanceof org.eclipse.fx.ui.controls.styledtext.model.Annotation).collect(Collectors.toSet());
            Set annotationHovers = e.getHoverTargets().stream().filter(t -> t.model instanceof org.eclipse.fx.ui.controls.styledtext.model.Annotation).map(t -> (org.eclipse.fx.ui.controls.styledtext.model.Annotation)t.model).filter(a -> a.getModel() instanceof Annotation).map(a -> (Annotation)a.getModel()).flatMap(a -> this.getTextViewer().getHoverInfo((Annotation)a).stream()).collect(Collectors.toSet());
            hovers.addAll(annotationHovers);
            if (!hovers.isEmpty()) {
                Point2D anchor = ((HoverTarget)e.getHoverTargets().get((int)0)).screenAnchor;
                Bounds bounds = ((HoverTarget)e.getHoverTargets().get((int)0)).screenBounds;
                if (!annotationHovers.isEmpty()) {
                    HoverTarget next = (HoverTarget)annotationTargets.iterator().next();
                    anchor = next.screenAnchor;
                    bounds = next.screenBounds;
                }
                this.windowPresenter.show(anchor, bounds, hovers);
            } else {
                this.windowPresenter.hide();
            }
        } else {
            this.windowPresenter.hide();
        }
    }

    public void install(StyledTextArea styledTextArea) {
        styledTextArea.addEventHandler(TextHoverEvent.MOUSE_PRESSED, event -> this.windowPresenter.hide());
        styledTextArea.addEventHandler(TextHoverEvent.HOVER, e -> this.doHovers((TextHoverEvent)e));
    }
}

