/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.renderers.fx.internal;

import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.fx.core.log.Logger;
import org.eclipse.fx.core.log.LoggerCreator;
import org.eclipse.fx.ui.controls.tabpane.DndTabPaneFactory;
import org.eclipse.fx.ui.controls.tabpane.GenericTab;
import org.eclipse.fx.ui.workbench.renderers.base.services.DnDFeedbackService;
import org.eclipse.fx.ui.workbench.renderers.base.services.DnDService;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WCallback;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WDragSourceWidget;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WDragTargetWidget;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WStack;
import org.eclipse.fx.ui.workbench.renderers.fx.internal.BaseDnDSupport;
import org.eclipse.fx.ui.workbench.services.ModelService;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class DnDSupport
extends BaseDnDSupport {
    private final @NonNull WCallback<@Nullable Void, @Nullable WCallback<// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull WDragSourceWidget.DragData, @NonNull Boolean>> dragStartCallbackProvider;
    private final @NonNull WCallback<@Nullable Void, @Nullable WCallback<// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull WDragTargetWidget.DropData, @Nullable Void>> dropCallbackProvider;
    private final @NonNull MPartStack stack;
    private static final @NonNull Logger LOGGER = LoggerCreator.createLogger(DnDSupport.class);
    private final @Nullable DnDService dndService;
    private final @NonNull ModelService modelService;

    public DnDSupport(@NonNull WCallback<@Nullable Void, @Nullable WCallback<// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull WDragSourceWidget.DragData, @NonNull Boolean>> dragStartCallbackProvider, @NonNull WCallback<@Nullable Void, @Nullable WCallback<// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull WDragTargetWidget.DropData, @Nullable Void>> dropCallbackProvider, @NonNull DnDFeedbackService feedbackService, @NonNull MPartStack stack, @Nullable DnDService dndService, @NonNull ModelService modelService) {
        super(feedbackService);
        this.dndService = dndService;
        this.dragStartCallbackProvider = dragStartCallbackProvider;
        this.dropCallbackProvider = dropCallbackProvider;
        this.stack = stack;
        this.modelService = modelService;
    }

    public @NonNull String clipboardDataFunction(@NonNull GenericTab tab) {
        MStackElement domElement = ((WStack.WStackItem)tab.getUserData()).getDomElement();
        String rv = null;
        if (domElement != null) {
            rv = this.modelService.getUniqueId((MApplicationElement)domElement);
        }
        if (rv != null) {
            return rv;
        }
        throw new IllegalStateException("The model element has no ID");
    }

    public @NonNull Boolean handleDragStart(@NonNull GenericTab tab) {
        WCallback dragStartCallback = (WCallback)this.dragStartCallbackProvider.call(null);
        if (dragStartCallback != null) {
            WStack.WStackItem item = (WStack.WStackItem)tab.getUserData();
            MStackElement itemElement = item.getDomElement();
            if (itemElement == null) {
                return Boolean.FALSE;
            }
            MPartStack itemContainer = (MPartStack)itemElement.getParent();
            if (itemContainer != null) {
                WDragSourceWidget.DragData dragData = new WDragSourceWidget.DragData((MUIElement)itemContainer, itemElement);
                if (((Boolean)dragStartCallback.call((Object)dragData)).booleanValue()) {
                    return Boolean.TRUE;
                }
            } else {
                LOGGER.error("Stack element '" + itemElement + "' has no container");
            }
        }
        return Boolean.FALSE;
    }

    public void handleDropped(DndTabPaneFactory.DroppedData data) {
        WCallback call = (WCallback)this.dropCallbackProvider.call(null);
        if (call != null) {
            if (data.dropType == DndTabPaneFactory.DropType.DETACH) {
                WStack.WStackItem sourceItem = (WStack.WStackItem)data.draggedTab.getUserData();
                MStackElement domElement = sourceItem.getDomElement();
                if (domElement != null) {
                    call.call((Object)new WDragTargetWidget.DropData(data.x, data.y, null, (MUIElement)domElement, (WDragTargetWidget.DropLocation)WDragTargetWidget.BasicDropLocation.DETACH));
                }
            } else {
                MElementContainer parentSource;
                MStackElement reference = ((WStack.WStackItem)data.targetTab.getUserData()).getDomElement();
                MStackElement sourceReference = ((WStack.WStackItem)data.draggedTab.getUserData()).getDomElement();
                MElementContainer parentRef = reference != null ? reference.getParent() : null;
                MElementContainer mElementContainer = parentSource = sourceReference != null ? sourceReference.getParent() : null;
                if (parentRef != parentSource && sourceReference != null && this.dndService != null && !this.dndService.repartentAllowed((MUIElement)sourceReference)) {
                    DnDSupport.cleanup();
                    return;
                }
                if (sourceReference != null) {
                    call.call((Object)new WDragTargetWidget.DropData(data.x, data.y, (MUIElement)reference, (MUIElement)sourceReference, (WDragTargetWidget.DropLocation)(data.dropType == DndTabPaneFactory.DropType.AFTER ? WDragTargetWidget.BasicDropLocation.AFTER : WDragTargetWidget.BasicDropLocation.BEFORE)));
                } else {
                    LOGGER.error("Source item '" + data.draggedTab.getUserData() + "' has no dom element attached");
                }
            }
        }
    }

    public void handleFeedback(DndTabPaneFactory.FeedbackData data) {
        MElementContainer parentSource;
        if (data.dropType == DndTabPaneFactory.DropType.NONE) {
            DnDSupport.cleanup();
            return;
        }
        MStackElement reference = ((WStack.WStackItem)data.targetTab.getUserData()).getDomElement();
        MStackElement sourceReference = ((WStack.WStackItem)data.draggedTab.getUserData()).getDomElement();
        MElementContainer parentRef = reference != null ? reference.getParent() : null;
        MElementContainer mElementContainer = parentSource = sourceReference != null ? sourceReference.getParent() : null;
        if (parentRef != parentSource && sourceReference != null && this.dndService != null && !this.dndService.repartentAllowed((MUIElement)sourceReference)) {
            DnDSupport.cleanup();
            return;
        }
        this.updateFeedback(new DnDFeedbackService.DnDFeedbackData((MUIElement)reference, (MUIElement)sourceReference, (WDragTargetWidget.DropLocation)(data.dropType == DndTabPaneFactory.DropType.AFTER ? WDragTargetWidget.BasicDropLocation.AFTER : WDragTargetWidget.BasicDropLocation.BEFORE), (MUIElement)this.stack, new DnDFeedbackService.Region(data.bounds.getMinX(), data.bounds.getMinY(), data.bounds.getWidth(), data.bounds.getHeight())));
    }

    public void handleFinished(GenericTab tab) {
        DnDSupport.cleanup();
    }
}

