/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.text.ui.source;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javafx.beans.property.SetProperty;
import org.eclipse.fx.text.hover.HoverInfo;
import org.eclipse.fx.text.ui.DefaultUndoManager;
import org.eclipse.fx.text.ui.Feature;
import org.eclipse.fx.text.ui.ITextHover;
import org.eclipse.fx.text.ui.IUndoManager;
import org.eclipse.fx.text.ui.contentassist.IContentAssistant;
import org.eclipse.fx.text.ui.presentation.IPresentationReconciler;
import org.eclipse.fx.text.ui.presentation.PresentationReconciler;
import org.eclipse.fx.text.ui.reconciler.IReconciler;
import org.eclipse.fx.text.ui.source.AnnotationPainter;
import org.eclipse.fx.text.ui.source.AnnotationPresenter;
import org.eclipse.fx.text.ui.source.ISourceViewer;
import org.eclipse.fx.text.ui.source.SourceViewer;
import org.eclipse.fx.ui.controls.styledtext.StyledTextArea;
import org.eclipse.fx.ui.controls.styledtext.TriggerActionMapping;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;

public abstract class SourceViewerConfiguration {
    private IUndoManager undoManager;

    public String getConfiguredDocumentPartitioning(ISourceViewer sourceViewer) {
        return "__dftl_partitioning";
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        reconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        return reconciler;
    }

    public abstract String getStyleclassName();

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        return null;
    }

    public IContentAssistant getContentAssist() {
        return null;
    }

    public IAnnotationModel getAnnotationModel() {
        return null;
    }

    public SetProperty<Feature> getFeatures() {
        return null;
    }

    public AnnotationPresenter getAnnotationPresenter() {
        return null;
    }

    public AnnotationPainter getAnnotationPainter(ISourceViewer sourceViewer) {
        return null;
    }

    public IUndoManager getUndoManager(ISourceViewer sourceViewer) {
        if (this.undoManager == null) {
            this.undoManager = new DefaultUndoManager(this.getMaxUndoLevel());
        }
        return this.undoManager;
    }

    protected int getMaxUndoLevel() {
        return 25;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        return null;
    }

    public Set<HoverInfo> getDocumentHoverInfo(IDocument document, int offset) {
        return Collections.emptySet();
    }

    public Set<HoverInfo> getAnnotationHoverInfo(Annotation annotation) {
        return Collections.emptySet();
    }

    public String[] getConfiguredContentTypes(SourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type"};
    }

    public Function<Integer, Optional<StyledTextArea.QuickLinkable>> getQuicklinkCallback() {
        return offset -> Optional.empty();
    }

    public TriggerActionMapping getOverrideMapping() {
        return null;
    }
}

