/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.renderers.base;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.ui.MContext;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.fx.ui.workbench.renderers.base.BaseRenderer;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WLayoutedWidget;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WPlaceholderWidget;

public abstract class BasePlaceholderRenderer<N>
extends BaseRenderer<MPlaceholder, WPlaceholderWidget> {
    @Inject
    @Named(value="EFX.RENDERING.SHARED_ELEMENTS_MAP")
    private Map<MUIElement, Set<MPlaceholder>> renderedMap;

    private Set<MPlaceholder> getRenderedPlaceholders(MUIElement element) {
        Set<MPlaceholder> set = this.renderedMap.get(element);
        if (set == null) {
            set = new HashSet<MPlaceholder>();
            this.renderedMap.put(element, set);
        }
        return set;
    }

    @Override
    protected void initWidget(MPlaceholder element, WPlaceholderWidget widget) {
        WLayoutedWidget refWidget;
        super.initWidget(element, widget);
        MUIElement ref = element.getRef();
        ref.setCurSharedRef(element);
        Set<MPlaceholder> set = this.getRenderedPlaceholders(ref);
        if (!set.contains(element)) {
            set.add(element);
        }
        if ((refWidget = (WLayoutedWidget)ref.getWidget()) == null) {
            ref.setToBeRendered(true);
            refWidget = (WLayoutedWidget)this.engineCreateWidget(ref, this.getContextForParent(ref));
        }
        widget.setContent(refWidget);
        if (ref instanceof MContext) {
            IEclipseContext context = ((MContext)ref).getContext();
            IEclipseContext newParentContext = this.getModelContext((MUIElement)element);
            if (context.getParent() != newParentContext) {
                context.setParent(newParentContext);
            }
        }
    }

    @Override
    public void destroyWidget(MPlaceholder element) {
        MUIElement refElement = element.getRef();
        Set<MPlaceholder> set = this.renderedMap.get(refElement);
        if (set != null) {
            set.remove(element);
        }
        if (set == null || set.isEmpty()) {
            if (refElement instanceof MPart) {
                MPart thePart = (MPart)refElement;
                String imageURI = thePart.getIconURI();
                thePart.setIconURI(null);
                thePart.setIconURI(imageURI);
            }
            this.getPresentationEngine().removeGui(refElement);
        } else {
            IEclipseContext curContext = this.modelService.getContainingContext((MUIElement)element);
            MPlaceholder currentRef = refElement.getCurSharedRef();
            IEclipseContext newParentContext = this.modelService.getContainingContext((MUIElement)currentRef);
            List allContexts = this.modelService.findElements(refElement, null, MContext.class, null);
            for (MContext ctxtElement : allContexts) {
                IEclipseContext theContext = ctxtElement.getContext();
                if (theContext == null || theContext.getParent() != curContext) continue;
                if (curContext.getActiveChild() == theContext) {
                    theContext.deactivate();
                }
                theContext.setParent(newParentContext);
            }
        }
        super.destroyWidget(element);
    }

    @Override
    protected void doProcessContent(MPlaceholder element) {
    }

    public void childRendered(MPlaceholder parentElement, MUIElement element) {
    }

    public void hideChild(MPlaceholder container, MUIElement changedObj) {
    }
}

