/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.ee.rs.container.responsecontext;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.common.client.JaxrsCommonClient;
import ee.jakarta.tck.ws.rs.common.client.TextCaser;
import ee.jakarta.tck.ws.rs.common.provider.PrintingErrorHandler;
import ee.jakarta.tck.ws.rs.common.provider.StringBean;
import ee.jakarta.tck.ws.rs.common.provider.StringBeanEntityProvider;
import ee.jakarta.tck.ws.rs.common.provider.StringBeanHeaderDelegate;
import ee.jakarta.tck.ws.rs.common.provider.StringBeanRuntimeDelegate;
import ee.jakarta.tck.ws.rs.common.provider.StringBeanWithAnnotation;
import ee.jakarta.tck.ws.rs.common.util.JaxrsUtil;
import ee.jakarta.tck.ws.rs.ee.rs.container.responsecontext.ContextOperation;
import ee.jakarta.tck.ws.rs.ee.rs.container.responsecontext.Resource;
import ee.jakarta.tck.ws.rs.ee.rs.container.responsecontext.ResponseFilter;
import ee.jakarta.tck.ws.rs.ee.rs.container.responsecontext.SecondResponseFilter;
import ee.jakarta.tck.ws.rs.ee.rs.container.responsecontext.TSAppConfig;
import ee.jakarta.tck.ws.rs.ee.rs.container.responsecontext.TemplateFilter;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.annotation.Priority;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.Provider;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class JAXRSClientIT
extends JaxrsCommonClient {
    private static final long serialVersionUID = 7090474648496503290L;

    public JAXRSClientIT() {
        this.setup();
        this.setContextRoot("/jaxrs_ee_rs_container_responsecontext_web/resource");
        this.setPrintEntity(true);
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        InputStream inStream = JAXRSClientIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/ws/rs/ee/rs/container/responsecontext/web.xml.template");
        String webXml = JAXRSClientIT.editWebXmlString(inStream);
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_ee_rs_container_responsecontext_web.war");
        archive.addClasses(new Class[]{TSAppConfig.class, Resource.class, ContextOperation.class, ResponseFilter.class, SecondResponseFilter.class, TemplateFilter.class, PrintingErrorHandler.class, StringBean.class, StringBeanEntityProvider.class, StringBeanHeaderDelegate.class, StringBeanRuntimeDelegate.class, StringBeanWithAnnotation.class, PrintingErrorHandler.class, JaxrsUtil.class});
        archive.setWebXML((Asset)new StringAsset(webXml));
        return archive;
    }

    @Test
    public void getAllowedMethodsTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.UNORDERED_SEARCH_STRING, "options");
        this.setProperty(JAXRSCommonClient.Property.UNORDERED_SEARCH_STRING, "trace");
        this.invokeRequestAndCheckResponse(JAXRSCommonClient.Request.GET, ContextOperation.GETALLOWEDMETHODS);
    }

    @Test
    public void getCookiesTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING_IGNORE_CASE, "CookieName");
        this.invokeRequestAndCheckResponse(JAXRSCommonClient.Request.GET, ContextOperation.GETCOOKIES);
    }

    @Test
    public void getCookiesIsReadOnlyTest() throws JAXRSCommonClient.Fault {
        this.invokeRequestAndCheckResponse(JAXRSCommonClient.Request.GET, ContextOperation.GETCOOKIESISREADONLY);
    }

    @Test
    public void getDateTest() throws JAXRSCommonClient.Fault {
        long date = System.currentTimeMillis();
        date = date / 1000L * 1000L;
        String value = String.valueOf(date);
        this.setProperty(JAXRSCommonClient.Property.CONTENT, value);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, value);
        this.invokeRequestAndCheckResponse(ContextOperation.GETDATE);
    }

    @Test
    public void getDateIsNullTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "0");
        this.invokeRequestAndCheckResponse(ContextOperation.GETDATE);
    }

    @Test
    public void getEntityTest() throws JAXRSCommonClient.Fault {
        String entity = this.getClass().getName() + "entity";
        this.setProperty(JAXRSCommonClient.Property.CONTENT, entity);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, entity + entity);
        this.invokeRequestAndCheckResponse(ContextOperation.GETENTITY);
    }

    @Test
    public void getEntityIsNullTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "NULL");
        this.invokeRequestAndCheckResponse(ContextOperation.GETENTITY);
    }

    @Test
    public void getEntityAnnotationsTest() throws JAXRSCommonClient.Fault {
        this.setTextCaser(TextCaser.LOWER);
        this.setProperty(JAXRSCommonClient.Property.UNORDERED_SEARCH_STRING, Provider.class.getName());
        this.setProperty(JAXRSCommonClient.Property.UNORDERED_SEARCH_STRING, Priority.class.getName());
        this.setProperty(JAXRSCommonClient.Property.UNORDERED_SEARCH_STRING, Path.class.getName());
        this.setProperty(JAXRSCommonClient.Property.UNORDERED_SEARCH_STRING, POST.class.getName());
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "true");
        this.invokeRequestAndCheckResponse(ContextOperation.GETENTITYANNOTATIONS);
    }

    @Test
    public void getEntityAnnotationsWhenNoAnnotationsTest() throws JAXRSCommonClient.Fault {
        this.setTextCaser(TextCaser.UPPER);
        this.setProperty(JAXRSCommonClient.Property.UNORDERED_SEARCH_STRING, Path.class.getName());
        this.setProperty(JAXRSCommonClient.Property.UNORDERED_SEARCH_STRING, POST.class.getName());
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "false");
        this.invokeRequestAndCheckResponse(ContextOperation.GETENTITYANNOTATIONS);
    }

    @Test
    public void getEntityAnnotationsWhenAnnotationsOnEntityTest() throws JAXRSCommonClient.Fault {
        String entity = "getEntityAnnotationsWhenAnnotationsOnEntityTest";
        this.setTextCaser(TextCaser.UPPER);
        this.setProperty(JAXRSCommonClient.Property.CONTENT, entity);
        this.setProperty(JAXRSCommonClient.Property.UNORDERED_SEARCH_STRING, entity);
        this.setProperty(JAXRSCommonClient.Property.UNORDERED_SEARCH_STRING, "2");
        this.invokeRequestAndCheckResponse(ContextOperation.GETENTITYANNOTATIONSONENTITY);
    }

    @Test
    public void getEntityClassStringTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "string");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, String.class.getName());
        this.invokeRequestAndCheckResponse(ContextOperation.GETENTITYCLASS);
    }

    @Test
    public void getEntityClassByteArrayTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "bytearray");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "[B");
        this.invokeRequestAndCheckResponse(ContextOperation.GETENTITYCLASS);
    }

    @Test
    public void getEntityClassInputStreamTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "inputstream");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, ByteArrayInputStream.class.getName());
        this.invokeRequestAndCheckResponse(ContextOperation.GETENTITYCLASS);
    }

    @Test
    public void getEntityStreamTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "ResponseFilterEntity");
        this.setProperty(JAXRSCommonClient.Property.UNEXPECTED_RESPONSE_MATCH, "NULL");
        this.invokeRequestAndCheckResponse(JAXRSCommonClient.Request.GET, ContextOperation.GETENTITYSTREAM);
    }

    @Test
    public void getEntityTagTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "ResponseFilterEntity");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "ResponseFilterEntity");
        this.invokeRequestAndCheckResponse(ContextOperation.GETENTITYTAG);
    }

    @Test
    public void getEntityTagIsNullTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "NULL");
        this.invokeRequestAndCheckResponse(ContextOperation.GETENTITYTAG);
    }

    @Test
    public void getEntityTypeStringTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "string");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, String.class.getName());
        this.invokeRequestAndCheckResponse(ContextOperation.GETENTITYTYPE);
    }

    @Test
    public void getEntityTypeByteArrayTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "bytearray");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "[B");
        this.invokeRequestAndCheckResponse(ContextOperation.GETENTITYTYPE);
    }

    @Test
    public void getEntityTypeInputStreamTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "inputstream");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, ByteArrayInputStream.class.getName());
        this.invokeRequestAndCheckResponse(ContextOperation.GETENTITYTYPE);
    }

    @Test
    public void containsHeaderStringTest() throws JAXRSCommonClient.Fault {
        String header = "Test";
        for (int i = 1; i != 6; ++i) {
            this.setProperty(JAXRSCommonClient.Property.UNORDERED_SEARCH_STRING, header + i);
        }
        this.setProperty(JAXRSCommonClient.Property.CONTENT, header);
        this.invokeRequestAndCheckResponse(ContextOperation.CONTAINSHEADERSTRING);
    }

    @Test
    public void getHeadersTest() throws JAXRSCommonClient.Fault {
        String header = "header";
        for (int i = 0; i != 5; ++i) {
            this.setProperty(JAXRSCommonClient.Property.UNORDERED_SEARCH_STRING, header + i);
        }
        this.setProperty(JAXRSCommonClient.Property.CONTENT, header);
        this.invokeRequestAndCheckResponse(ContextOperation.GETHEADERS);
    }

    @Test
    public void getHeadersIsMutableTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "HEADER");
        this.invokeRequestAndCheckResponse(JAXRSCommonClient.Request.GET, ContextOperation.GETHEADERSISMUTABLE);
    }

    @Test
    public void getHeaderStringTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, ContextOperation.GETHEADERSTRINGOPERATION.name());
        this.invokeRequestAndCheckResponse(JAXRSCommonClient.Request.GET, ContextOperation.GETHEADERSTRINGOPERATION);
    }

    @Test
    public void getHeaderStringHeaderIsNullTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "NULL");
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "null");
        this.invokeRequestAndCheckResponse(ContextOperation.GETHEADERSTRINGHEADER);
    }

    @Test
    public void getHeaderStringHeaderUsesToStringMethodTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "ResponseFilterEntity");
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "toString");
        this.invokeRequestAndCheckResponse(ContextOperation.GETHEADERSTRINGHEADER);
    }

    @Test
    public void getHeaderStringHeaderUsesHeaderDelegateTest() throws JAXRSCommonClient.Fault {
        this.invokeRequestAndCheckResponse(JAXRSCommonClient.Request.GET, ContextOperation.SETSTRINGBEANRUNTIME);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "ResponseFilterEntity");
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "headerDelegate");
        this.invokeRequestAndCheckResponse(ContextOperation.GETHEADERSTRINGHEADER);
        this.invokeRequestAndCheckResponse(JAXRSCommonClient.Request.GET, ContextOperation.SETORIGINALRUNTIME);
    }

    @Test
    public void getHeaderStringHeaderIsCommaSepearatedTest() throws JAXRSCommonClient.Fault {
        String entity = "ResponseFilterEntity,ResponseFilterEntity";
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, entity);
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "commaSeparated");
        this.invokeRequestAndCheckResponse(ContextOperation.GETHEADERSTRINGHEADER);
    }

    @Test
    public void getLanguageTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "fr-ca");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, Locale.CANADA_FRENCH.toString());
        this.invokeRequestAndCheckResponse(ContextOperation.GETLANGUAGE);
    }

    @Test
    public void getLanguageIsNullTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "NULL");
        this.invokeRequestAndCheckResponse(ContextOperation.GETLANGUAGE);
    }

    @Test
    public void getLastModifiedTest() throws JAXRSCommonClient.Fault {
        long milis = System.currentTimeMillis();
        milis = milis / 1000L * 1000L;
        String lastModified = String.valueOf(milis);
        this.setProperty(JAXRSCommonClient.Property.CONTENT, lastModified);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, lastModified);
        this.invokeRequestAndCheckResponse(ContextOperation.GETLASTMODIFIED);
    }

    @Test
    public void getLastModifiedIsNullTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "NULL");
        this.invokeRequestAndCheckResponse(ContextOperation.GETLASTMODIFIED);
    }

    @Test
    public void getLengthTest() throws JAXRSCommonClient.Fault {
        String entity = "ResponseFilterEntity";
        this.setProperty(JAXRSCommonClient.Property.CONTENT, entity);
        String search = ResponseFilter.replaceStart(entity, entity.length());
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, search);
        this.invokeRequestAndCheckResponse(ContextOperation.GETLENGTH);
    }

    @Test
    public void getLengthWhenNoEntityTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "-1");
        this.invokeRequestAndCheckResponse(ContextOperation.GETLENGTH);
    }

    @Test
    public void getLinkTest() throws JAXRSCommonClient.Fault {
        String url = this.getAbsoluteUrl();
        this.setProperty(JAXRSCommonClient.Property.CONTENT, url);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, url);
        this.invokeRequestAndCheckResponse(ContextOperation.GETLINK);
    }

    @Test
    public void getLinkWhenNoLinkTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "NULL");
        this.invokeRequestAndCheckResponse(ContextOperation.GETLINK);
    }

    @Test
    public void getLinkBuilderTest() throws JAXRSCommonClient.Fault {
        String url = this.getAbsoluteUrl();
        this.setProperty(JAXRSCommonClient.Property.CONTENT, url);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, url);
        this.invokeRequestAndCheckResponse(ContextOperation.GETLINKBUILDER);
    }

    @Test
    public void getLinkBuilderWhenNoLinkTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "NULL");
        this.invokeRequestAndCheckResponse(ContextOperation.GETLINKBUILDER);
    }

    @Test
    public void getLinksTest() throws JAXRSCommonClient.Fault {
        String uri1 = this.getAbsoluteUrl();
        String uri2 = "html://localhost:8080/nohttp";
        this.setProperty(JAXRSCommonClient.Property.CONTENT, uri1 + ";" + uri2);
        this.setProperty(JAXRSCommonClient.Property.UNORDERED_SEARCH_STRING, uri1);
        this.setProperty(JAXRSCommonClient.Property.UNORDERED_SEARCH_STRING, uri2);
        this.invokeRequestAndCheckResponse(ContextOperation.GETLINKS);
    }

    @Test
    public void getLinksWhenNoLinkTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "NULL");
        this.invokeRequestAndCheckResponse(ContextOperation.GETLINKS);
    }

    @Test
    public void getLocationTest() throws JAXRSCommonClient.Fault {
        String uri = this.getAbsoluteUrl();
        this.setProperty(JAXRSCommonClient.Property.CONTENT, uri);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, uri);
        this.invokeRequestAndCheckResponse(ContextOperation.GETLOCATION);
    }

    @Test
    public void getLocationWhenNoLocationTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "NULL");
        this.invokeRequestAndCheckResponse(ContextOperation.GETLOCATION);
    }

    @Test
    public void getMediaTypeTest() throws JAXRSCommonClient.Fault {
        String uri = "application/svg+xml";
        this.setProperty(JAXRSCommonClient.Property.CONTENT, uri);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, uri);
        this.invokeRequestAndCheckResponse(ContextOperation.GETMEDIATYPE);
    }

    @Test
    public void getMediaTypeWhenNoMediaTypeTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "NULL");
        this.invokeRequestAndCheckResponse(ContextOperation.GETMEDIATYPE);
    }

    @Test
    public void getStatusTest() throws JAXRSCommonClient.Fault {
        for (Response.Status status : Response.Status.values()) {
            String content = String.valueOf(status.getStatusCode());
            this.setProperty(JAXRSCommonClient.Property.CONTENT, content);
            this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, content);
            this.invokeRequestAndCheckResponse(ContextOperation.GETSTATUS);
        }
    }

    @Test
    public void getStatusInfoTest() throws JAXRSCommonClient.Fault {
        for (Response.Status status : Response.Status.values()) {
            String content = String.valueOf(status.getStatusCode());
            this.setProperty(JAXRSCommonClient.Property.CONTENT, content);
            this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, content);
            this.invokeRequestAndCheckResponse(ContextOperation.GETSTATUSINFO);
        }
    }

    @Test
    public void getStringHeadersTest() throws JAXRSCommonClient.Fault {
        String entity = "EnTITY";
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, entity);
        this.setProperty(JAXRSCommonClient.Property.CONTENT, entity);
        this.invokeRequestAndCheckResponse(ContextOperation.GETSTRINGHEADERS);
    }

    @Test
    public void getStringHeadersHeaderIsNullTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "NULL");
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "null");
        this.invokeRequestAndCheckResponse(ContextOperation.GETSTRINGHEADERS);
    }

    @Test
    public void getStringHeadersUsesToStringMethodTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "ResponseFilterEntity");
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "toString");
        this.invokeRequestAndCheckResponse(ContextOperation.GETSTRINGHEADERS);
    }

    @Test
    public void getStringHeadersUsesHeaderDelegateTest() throws JAXRSCommonClient.Fault {
        this.invokeRequestAndCheckResponse(JAXRSCommonClient.Request.GET, ContextOperation.SETSTRINGBEANRUNTIME);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "ResponseFilterEntity");
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "headerDelegate");
        this.invokeRequestAndCheckResponse(ContextOperation.GETSTRINGHEADERS);
        this.invokeRequestAndCheckResponse(JAXRSCommonClient.Request.GET, ContextOperation.SETORIGINALRUNTIME);
    }

    @Test
    public void getStringsHeaderMoreItemsTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING_IGNORE_CASE, "ResponseFilterEntity");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING_IGNORE_CASE, "ResponseFilterEntity");
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "commaSeparated");
        this.invokeRequestAndCheckResponse(ContextOperation.GETSTRINGHEADERS);
    }

    @Test
    public void hasEntityTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "ResponseFilterEntity");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "true");
        this.invokeRequestAndCheckResponse(ContextOperation.HASENTITY);
    }

    @Test
    public void hasEntityWhenNoEntityTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "false");
        this.invokeRequestAndCheckResponse(ContextOperation.HASENTITY);
    }

    @Test
    public void hasLinkTest() throws JAXRSCommonClient.Fault {
        String url = this.getAbsoluteUrl();
        this.setProperty(JAXRSCommonClient.Property.CONTENT, url);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "true");
        this.invokeRequestAndCheckResponse(ContextOperation.HASLINK);
    }

    @Test
    public void hasLinkWhenNoLinkTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "false");
        this.invokeRequestAndCheckResponse(ContextOperation.HASLINK);
    }

    @Test
    public void setEntityTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "ResponseFilterEntity");
        this.invokeRequestAndCheckResponse(JAXRSCommonClient.Request.GET, ContextOperation.SETENTITY);
    }

    @Test
    public void setEntityStreamTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "ResponseFilterEntity");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "OK");
        this.invokeRequestAndCheckResponse(JAXRSCommonClient.Request.GET, ContextOperation.SETENTITYSTREAM);
    }

    @Test
    public void setStatusTest() throws JAXRSCommonClient.Fault {
        for (Response.Status status : Response.Status.values()) {
            String content = String.valueOf(status.getStatusCode());
            this.setProperty(JAXRSCommonClient.Property.CONTENT, content);
            this.setProperty(JAXRSCommonClient.Property.STATUS_CODE, content);
            this.invokeRequestAndCheckResponse(ContextOperation.SETSTATUS);
        }
    }

    @Test
    public void setStatusInfoTest() throws JAXRSCommonClient.Fault {
        for (Response.Status status : Response.Status.values()) {
            String content = String.valueOf(status.getStatusCode());
            this.setProperty(JAXRSCommonClient.Property.CONTENT, content);
            this.setProperty(JAXRSCommonClient.Property.STATUS_CODE, content);
            this.invokeRequestAndCheckResponse(ContextOperation.SETSTATUSINFO);
        }
    }

    protected void invokeRequestAndCheckResponse(ContextOperation operation) throws JAXRSCommonClient.Fault {
        String request = this.buildRequest(JAXRSCommonClient.Request.POST, operation.name().toLowerCase());
        this.setProperty(JAXRSCommonClient.Property.REQUEST, request);
        this.invoke();
    }

    protected void invokeRequestAndCheckResponse(JAXRSCommonClient.Request method, ContextOperation operation) throws JAXRSCommonClient.Fault {
        String request = this.buildRequest(method, operation.name().toLowerCase());
        this.setProperty(JAXRSCommonClient.Property.REQUEST, request);
        this.invoke();
    }
}

