/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.sirius;

import org.eclipse.emf.diffmerge.ui.gmf.GMFDiffMergeLabelProvider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.diagram.ContainerStyle;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.EdgeStyle;
import org.eclipse.sirius.diagram.NodeStyle;
import org.eclipse.sirius.viewpoint.BasicLabelStyle;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.DView;
import org.eclipse.sirius.viewpoint.RGBValues;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

public class SiriusDiffMergeLabelProvider
extends GMFDiffMergeLabelProvider {
    private static SiriusDiffMergeLabelProvider __instance = null;

    public static SiriusDiffMergeLabelProvider getInstance() {
        if (__instance == null) {
            __instance = new SiriusDiffMergeLabelProvider();
        }
        return __instance;
    }

    protected String getRepresentationElementText(DRepresentationElement representationElement_p) {
        String result = this.getExplicitlyTypedElementText(representationElement_p.getName(), representationElement_p.getMapping());
        return result;
    }

    protected String getRGBValuesText(RGBValues element_p) {
        StringBuilder builder = new StringBuilder();
        builder.append('(');
        builder.append(element_p.getRed());
        builder.append(',');
        builder.append(element_p.getGreen());
        builder.append(',');
        builder.append(element_p.getBlue());
        builder.append(')');
        return builder.toString();
    }

    public String getText(Object element_p) {
        String result = null;
        if (element_p instanceof DAnalysis) {
            DAnalysis analysis = (DAnalysis)element_p;
            Resource resource = analysis.eResource();
            if (resource != null && resource.getURI() != null) {
                result = resource.getURI().lastSegment();
            }
            if (result == null) {
                result = super.getText((Object)analysis);
            }
        } else if (element_p instanceof DView) {
            DView representationContainer = (DView)element_p;
            Viewpoint viewpoint = representationContainer.getViewpoint();
            if (viewpoint != null && (result = viewpoint.getLabel()) == null) {
                result = viewpoint.getName();
            }
        } else if (element_p instanceof DRepresentationElement) {
            result = this.getRepresentationElementText((DRepresentationElement)element_p);
        } else if (element_p instanceof NodeStyle) {
            result = String.valueOf(((EObject)element_p).eClass().getName()) + " " + this.formatTechnicalName(DiagramPackage.eINSTANCE.getNodeStyle().getName());
        } else if (element_p instanceof ContainerStyle || element_p instanceof EdgeStyle || element_p instanceof BasicLabelStyle) {
            result = this.getManyQualifiedElementText((EObject)element_p, new Object[0]);
        } else if (element_p instanceof RGBValues) {
            result = this.getRGBValuesText((RGBValues)element_p);
        }
        if (result == null) {
            result = super.getText(element_p);
        }
        return result;
    }
}

