/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.impl.scopes;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.diffmerge.api.scopes.IFeaturedModelScope;
import org.eclipse.emf.diffmerge.impl.scopes.MultiRootTreeIterator;
import org.eclipse.emf.diffmerge.util.structures.FHashSet;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.ecore.util.InternalEList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractModelScope
implements IFeaturedModelScope {
    @Override
    public boolean add(EObject source_p, EAttribute attribute_p, Object value_p) {
        boolean result;
        if (FeatureMapUtil.isMany((EObject)source_p, (EStructuralFeature)attribute_p)) {
            List values = (List)source_p.eGet((EStructuralFeature)attribute_p, this.resolveProxies());
            result = values.add(value_p);
        } else {
            source_p.eSet((EStructuralFeature)attribute_p, value_p);
            result = true;
        }
        return result;
    }

    @Override
    public boolean add(EObject source_p, EReference reference_p, EObject value_p) {
        boolean result;
        if (FeatureMapUtil.isMany((EObject)source_p, (EStructuralFeature)reference_p)) {
            List values = (List)source_p.eGet((EStructuralFeature)reference_p, this.resolveProxies());
            result = values.add(value_p);
        } else {
            source_p.eSet((EStructuralFeature)reference_p, (Object)value_p);
            result = true;
        }
        return result;
    }

    @Override
    public boolean covers(EObject element_p) {
        TreeIterator<EObject> it = this.getAllContents();
        while (it.hasNext()) {
            EObject current = (EObject)it.next();
            if (current != element_p) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<EObject> get(EObject source_p, EReference reference_p) {
        return this.get(source_p, reference_p, this.resolveProxies());
    }

    protected List<EObject> get(EObject source_p, EReference reference_p, boolean resolveProxies_p) {
        List<Object> result = Collections.emptyList();
        try {
            if (source_p.eIsSet((EStructuralFeature)reference_p)) {
                Object value = source_p.eGet((EStructuralFeature)reference_p, resolveProxies_p);
                if (FeatureMapUtil.isMany((EObject)source_p, (EStructuralFeature)reference_p)) {
                    List values = (List)value;
                    if (!resolveProxies_p && values instanceof InternalEList) {
                        values = ((InternalEList)values).basicList();
                    }
                    result = Collections.unmodifiableList(values);
                } else if (value != null) {
                    result = Collections.singletonList((EObject)value);
                }
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return result;
    }

    @Override
    public List<Object> get(EObject source_p, EAttribute attribute_p) {
        List<Object> result;
        try {
            if (source_p.eIsSet((EStructuralFeature)attribute_p)) {
                Object value = source_p.eGet((EStructuralFeature)attribute_p, this.resolveProxies());
                result = FeatureMapUtil.isMany((EObject)source_p, (EStructuralFeature)attribute_p) ? Collections.unmodifiableList((List)value) : (value != null ? Collections.singletonList(value) : Collections.emptyList());
            } else {
                result = Collections.emptyList();
            }
        }
        catch (RuntimeException e) {
            result = Collections.emptyList();
        }
        return result;
    }

    @Override
    public TreeIterator<EObject> getAllContents() {
        return new MultiRootTreeIterator(this, this.getContents().iterator());
    }

    @Override
    public TreeIterator<EObject> getAllContents(EObject root_p) {
        return new AbstractTreeIterator<EObject>((Object)root_p, false){

            public Iterator<EObject> getChildren(Object object_p) {
                return AbstractModelScope.this.getContents((EObject)object_p).iterator();
            }
        };
    }

    @Override
    public Set<EObject> getAllContentsAsSet() {
        FHashSet<EObject> result = new FHashSet<EObject>();
        TreeIterator<EObject> it = this.getAllContents();
        while (it.hasNext()) {
            result.add((EObject)it.next());
        }
        return Collections.unmodifiableSet(result);
    }

    @Override
    public EObject getContainer(EObject element_p) {
        return element_p.eContainer();
    }

    @Override
    public EReference getContainment(EObject element_p) {
        return element_p.eContainmentFeature();
    }

    @Override
    public List<EObject> getContents(EObject element_p) {
        return element_p.eContents();
    }

    @Override
    public Object move(EObject source_p, EStructuralFeature feature_p, int newPosition_p, int oldPosition_p) {
        Object result = null;
        if (FeatureMapUtil.isMany((EObject)source_p, (EStructuralFeature)feature_p) && source_p.eIsSet(feature_p) && newPosition_p >= 0) {
            int newPosition;
            EList values = (EList)source_p.eGet(feature_p, false);
            int size = values.size();
            int oldPosition = oldPosition_p >= 0 ? oldPosition_p : size - 1;
            int n = newPosition = oldPosition >= newPosition_p ? newPosition_p : newPosition_p - 1;
            if (newPosition < size && oldPosition < size) {
                try {
                    result = values.move(newPosition, oldPosition);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    @Override
    public boolean remove(EObject element_p) {
        EcoreUtil.remove((EObject)element_p);
        return true;
    }

    @Override
    public boolean remove(EObject source_p, EAttribute attribute_p, Object value_p) {
        return this.removeValue(source_p, (EStructuralFeature)attribute_p, value_p);
    }

    @Override
    public boolean remove(EObject source_p, EReference reference_p, EObject value_p) {
        return this.removeValue(source_p, (EStructuralFeature)reference_p, value_p);
    }

    protected boolean removeValue(EObject source_p, EStructuralFeature feature_p, Object value_p) {
        boolean result = false;
        if (FeatureMapUtil.isMany((EObject)source_p, (EStructuralFeature)feature_p)) {
            result = ((List)source_p.eGet(feature_p)).remove(value_p);
        } else if (source_p.eGet(feature_p) == value_p) {
            source_p.eUnset(feature_p);
            result = true;
        }
        return result;
    }

    protected boolean resolveProxies() {
        return false;
    }

    @Override
    public int size() {
        int result = 0;
        TreeIterator<EObject> it = this.getAllContents();
        while (it.hasNext()) {
            ++result;
        }
        return result;
    }
}

