/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.util;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAnnotationValidator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.BasicEAnnotationValidator;
import org.eclipse.emf.ecore.util.BasicExtendedMetaData;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.ecore.util.EcoreSwitch;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.emf.ecore.xml.type.util.XMLTypeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExtendedMetaDataAnnotationValidator
extends BasicEAnnotationValidator {
    public static final ExtendedMetaDataAnnotationValidator INSTANCE = new ExtendedMetaDataAnnotationValidator();
    public static final String DIAGNOSTIC_SOURCE = "org.eclipse.emf.ecore.annotation.extended.meta.data";
    public static final int INVALID_VALUE_LITERAL = 5;
    public static final int IGNORED_ENTRY = 12;
    private static String INSTANCE_VALUE;

    static {
        if (!EAnnotationValidator.Registry.INSTANCE.containsKey("http:///org/eclipse/emf/ecore/util/ExtendedMetaData")) {
            EAnnotationValidator.Registry.INSTANCE.put("http:///org/eclipse/emf/ecore/util/ExtendedMetaData", INSTANCE);
        }
        PropertySwitch.GETTERS.isEmpty();
        INSTANCE_VALUE = "extended_meta_data_instance_value";
    }

    public ExtendedMetaDataAnnotationValidator() {
        super("http:///org/eclipse/emf/ecore/util/ExtendedMetaData", "ExtendedMetaData", DIAGNOSTIC_SOURCE);
    }

    @Override
    protected ResourceLocator getResourceLocator() {
        return this.getEcoreResourceLocator();
    }

    @Override
    protected EObject initialize(EObject eObject, EAnnotation eAnnotation) {
        ModelObject result = (ModelObject)eObject;
        result.setElement((ENamedElement)eAnnotation.getEModelElement());
        return result;
    }

    @Override
    protected boolean isApplicable(EObject eObject, EStructuralFeature eStructuralFeature) {
        return ((ModelObject)eObject).isApplicable(eStructuralFeature);
    }

    @Override
    protected boolean isValidLocation(EAnnotation eAnnotation, EModelElement eModelElement) {
        return this.getPropertyClass(eModelElement) != null;
    }

    @Override
    protected List<EClass> getPropertyClasses(EModelElement eModelElement) {
        EClass propertyClass = this.getPropertyClass(eModelElement);
        return propertyClass == null ? Collections.emptyList() : Collections.singletonList(propertyClass);
    }

    private EClass getPropertyClass(EModelElement eModelElement) {
        final AtomicReference result = new AtomicReference();
        new PropertySwitch(){

            protected void addFeatures(EClass eClass) {
                result.set(eClass);
            }
        }.doSwitch(eModelElement);
        return (EClass)result.get();
    }

    @Override
    protected boolean validateDetails(EAnnotation eAnnotation, EModelElement eModelElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (context == null) {
            context = new HashMap<Object, Object>();
        }
        EClass propertyClass = this.getPropertyClass(eModelElement);
        ModelObject modelObject = (ModelObject)this.createInstance(propertyClass, eAnnotation);
        try {
            context.put(INSTANCE_VALUE, modelObject);
            boolean bl = super.validateDetails(eAnnotation, eModelElement, diagnostics, context);
            return bl;
        }
        finally {
            context.remove(INSTANCE_VALUE);
        }
    }

    @Override
    protected boolean validateFeatureDetail(EAnnotation eAnnotation, EModelElement eModelElement, Map.Entry<String, String> entry, EStructuralFeature feature, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.getModelObject(context).validateEntry(this, entry, diagnostics, context);
        if (result) {
            result = super.validateFeatureDetail(eAnnotation, eModelElement, entry, feature, diagnostics, context);
        }
        return result;
    }

    @Override
    protected boolean validateReferenceDetailValueLiteral(EAnnotation eAnnotation, EModelElement eModelElement, Map.Entry<String, String> entry, EReference reference, String literalValue, List<Object> referenceValues, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.getModelObject(context).validateEntryValueLiteral(this, entry, literalValue, referenceValues, diagnostics, context);
    }

    @Override
    protected boolean validateFeatureDetailValue(EAnnotation eAnnotation, EModelElement eModelElement, Map.Entry<String, String> entry, EStructuralFeature feature, List<Object> values, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.getModelObject(context).validateEntryValue(this, entry, values, diagnostics, context);
    }

    private ModelObject getModelObject(Map<Object, Object> context) {
        return (ModelObject)context.get(INSTANCE_VALUE);
    }

    public Collection<?> filterChoiceOfValues(EObject eObject, EStructuralFeature eStructuralFeature, Collection<?> choiceOfValues) {
        return ((ModelObject)eObject).filterChoiceOfValues(eStructuralFeature, choiceOfValues);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ModelObject
    extends MinimalEObjectImpl.Container.Dynamic {
        protected SpecializedExtendedMetaData extendedMetaData;
        protected ENamedElement eNamedElement;

        private ModelObject() {
        }

        public void setElement(ENamedElement eNamedElement) {
            if (INSTANCE.getPropertyClass(eNamedElement) != this.eClass()) {
                throw new IllegalArgumentException();
            }
            this.extendedMetaData = SpecializedExtendedMetaData.getExtendedMetaData(eNamedElement);
            this.eNamedElement = eNamedElement;
        }

        @Override
        public Object eGet(EStructuralFeature eStructuralFeature) {
            EClassifier eType = eStructuralFeature.getEType();
            String name = eStructuralFeature.getName();
            Method method = (Method)PropertySwitch.GETTERS.get(eStructuralFeature);
            try {
                EList result = method.invoke((Object)this.extendedMetaData, this.eNamedElement);
                if (name.equals("wildcards")) {
                    EList wildcards = ECollections.asEList(result);
                    int index = wildcards.indexOf(null);
                    if (index != -1) {
                        wildcards.set(index, "##local");
                    }
                    return wildcards;
                }
                return eType instanceof EEnum ? ((EEnum)eType).getEEnumLiteral((Integer)((Object)result)) : (eStructuralFeature.isMany() ? ECollections.asEList(result) : result);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public void eSet(EStructuralFeature eStructuralFeature, Object value) {
            Method method = (Method)PropertySwitch.SETTERS.get(eStructuralFeature);
            try {
                if (value instanceof Enumerator) {
                    method.invoke((Object)this.extendedMetaData, this.eNamedElement, ((Enumerator)value).getValue());
                } else {
                    method.invoke((Object)this.extendedMetaData, this.eNamedElement, value);
                }
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public void eUnset(EStructuralFeature eStructuralFeature) {
            EAnnotation eAnnotation = this.eNamedElement.getEAnnotation("http:///org/eclipse/emf/ecore/util/ExtendedMetaData");
            if (eAnnotation != null) {
                eAnnotation.getDetails().removeKey(eStructuralFeature.getName());
            }
        }

        @Override
        public boolean eIsSet(EStructuralFeature eStructuralFeature) {
            EAnnotation eAnnotation = this.eNamedElement.getEAnnotation("http:///org/eclipse/emf/ecore/util/ExtendedMetaData");
            return eAnnotation != null && eAnnotation.getDetails().get(eStructuralFeature.getName()) != null;
        }

        public boolean isApplicable(EStructuralFeature eStructuralFeature) {
            Method method = (Method)PropertySwitch.ENTRY_VALIDATORS.get(this.eClass);
            EMap<String, String> details = EcoreFactory.eINSTANCE.createEAnnotation().getDetails();
            details.put(eStructuralFeature.getName(), null);
            try {
                return (Boolean)method.invoke((Object)this.extendedMetaData, this.eNamedElement, details.get(0), null, null);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        public Collection<?> filterChoiceOfValues(EStructuralFeature eStructuralFeature, Collection<?> choiceOfValues) {
            ArrayList<Object> result;
            block27: {
                String name;
                block31: {
                    block30: {
                        block29: {
                            block28: {
                                String namespace;
                                EClass eContainingClass;
                                block26: {
                                    result = new ArrayList<Object>();
                                    if (choiceOfValues != null) {
                                        result.addAll(choiceOfValues);
                                    }
                                    if (!(name = eStructuralFeature.getName()).equals("kind")) break block26;
                                    if (!eStructuralFeature.getEContainingClass().getName().equals("StructuralFeature") || !(this.eNamedElement instanceof EReference)) break block27;
                                    for (Object object : choiceOfValues) {
                                        String literal = object.toString();
                                        if (!literal.equals("group") && !literal.equals("elementWildcard") && !literal.equals("attributeWildcard")) continue;
                                        result.remove(object);
                                    }
                                    break block27;
                                }
                                if (!name.equals("namespace")) break block28;
                                EStructuralFeature targetFeature = (EStructuralFeature)this.eNamedElement;
                                for (Object object : choiceOfValues) {
                                    EStructuralFeature element;
                                    EPackage ePackage;
                                    String namespace2;
                                    result.remove(object);
                                    if (!(object instanceof EPackage) || (namespace2 = this.extendedMetaData.getNamespace(ePackage = (EPackage)object)) == null) continue;
                                    int featureKind = this.extendedMetaData.getFeatureKind(targetFeature);
                                    String targetName = this.extendedMetaData.getName(targetFeature);
                                    EStructuralFeature eStructuralFeature2 = featureKind == 4 ? this.extendedMetaData.getElement(namespace2, targetName) : (element = featureKind == 2 ? this.extendedMetaData.getAttribute(namespace2, targetName) : null);
                                    if (element == null) continue;
                                    result.add(namespace2);
                                }
                                String targetNamespace = this.extendedMetaData.getNamespace(targetFeature);
                                if (targetNamespace != null && !"".equals(targetNamespace) && !result.contains(targetNamespace)) {
                                    result.add(targetNamespace);
                                }
                                if ((eContainingClass = targetFeature.getEContainingClass()) != null && (namespace = this.extendedMetaData.getNamespace(eContainingClass)) != null && !"".equals(namespace) && !result.contains(namespace)) {
                                    result.add(namespace);
                                }
                                result.add("");
                                break block27;
                            }
                            if (!name.equals("wildcards")) break block29;
                            for (Object object : choiceOfValues) {
                                String namespace;
                                EPackage ePackage;
                                result.remove(object);
                                if (!(object instanceof EPackage) || this.extendedMetaData.getDocumentRoot(ePackage = (EPackage)object) == null || "http://www.eclipse.org/emf/2003/XMLType".equals(namespace = this.extendedMetaData.getNamespace(ePackage))) continue;
                                result.add(namespace);
                            }
                            EStructuralFeature targetFeature = (EStructuralFeature)this.eNamedElement;
                            EClass eContainingClass = targetFeature.getEContainingClass();
                            if (eContainingClass != null) {
                                String namespace = this.extendedMetaData.getNamespace(eContainingClass);
                                result.add("!##" + namespace);
                            }
                            result.add("##any");
                            result.add("##local");
                            break block27;
                        }
                        if (!name.equals("group")) break block30;
                        result.clear();
                        for (EAttribute eAttribute : ((EStructuralFeature)this.eNamedElement).getEContainingClass().getEAllAttributes()) {
                            if (this.extendedMetaData.getFeatureKind(eAttribute) != 6 || eAttribute == this.eNamedElement) continue;
                            result.add(eAttribute);
                        }
                        result.add(null);
                        break block27;
                    }
                    if (!name.equals("affiliation")) break block31;
                    EStructuralFeature targetFeature = (EStructuralFeature)this.eNamedElement;
                    EClassifier eType = targetFeature.getEType();
                    block4: for (Object object : choiceOfValues) {
                        if (!(object instanceof EStructuralFeature)) continue;
                        EStructuralFeature feature = (EStructuralFeature)object;
                        EClass eContainingClass = feature.getEContainingClass();
                        if (eType == null || eContainingClass == null || !this.extendedMetaData.isDocumentRoot(eContainingClass) || "http://www.eclipse.org/emf/2003/XMLType".equals(this.extendedMetaData.getNamespace(eContainingClass)) || this.extendedMetaData.getFeatureKind(feature) != 4 || !this.isSuperTypeOf(feature.getEType(), eType)) {
                            result.remove(object);
                            continue;
                        }
                        LinkedHashSet<EStructuralFeature> affiliations = new LinkedHashSet<EStructuralFeature>();
                        EStructuralFeature affiliation = feature;
                        while (affiliation != null && affiliations.add(affiliation)) {
                            if (targetFeature == affiliation) {
                                result.remove(object);
                                continue block4;
                            }
                            affiliation = this.extendedMetaData.getAffiliation(affiliation);
                        }
                    }
                    EStructuralFeature affiliation = this.extendedMetaData.getAffiliation(targetFeature);
                    if (affiliation == null || result.contains(affiliation)) break block27;
                    result.add(affiliation);
                    break block27;
                }
                if (name.equals("baseType")) {
                    EDataType eDataType = (EDataType)this.eNamedElement;
                    for (Object object : choiceOfValues) {
                        if (!(object instanceof EDataType)) continue;
                        EDataType dataType = (EDataType)object;
                        if (!this.isSuperTypeOf(eDataType, dataType)) {
                            result.remove(object);
                            continue;
                        }
                        if (eDataType.isSerializable() && !dataType.isSerializable()) {
                            result.remove(object);
                            continue;
                        }
                        if (!this.extendedMetaData.getInheritedTypes(dataType).contains(eDataType)) continue;
                        result.remove(object);
                    }
                } else if (name.equals("itemType")) {
                    EDataType eDataType = (EDataType)this.eNamedElement;
                    for (Object object : choiceOfValues) {
                        if (!(object instanceof EDataType)) continue;
                        EDataType dataType = (EDataType)object;
                        Class<?> instanceClass = dataType.getInstanceClass();
                        if (instanceClass != null && Collection.class.isAssignableFrom(instanceClass)) {
                            result.remove(object);
                            continue;
                        }
                        if (eDataType.isSerializable() && !dataType.isSerializable()) {
                            result.remove(object);
                            continue;
                        }
                        if (!this.extendedMetaData.getInheritedTypes(dataType).contains(eDataType)) continue;
                        result.remove(object);
                    }
                } else if (name.equals("memberTypes")) {
                    EDataType eDataType = (EDataType)this.eNamedElement;
                    for (Object object : choiceOfValues) {
                        if (!(object instanceof EDataType)) continue;
                        EDataType dataType = (EDataType)object;
                        if (!this.isSuperTypeOf(eDataType, dataType)) {
                            result.remove(object);
                            continue;
                        }
                        if (eDataType.isSerializable() && !dataType.isSerializable()) {
                            result.remove(object);
                            continue;
                        }
                        if (!this.extendedMetaData.getInheritedTypes(dataType).contains(eDataType)) continue;
                        result.remove(object);
                    }
                }
            }
            return choiceOfValues == null && result.isEmpty() ? null : result;
        }

        private boolean isSuperTypeOf(EClassifier eClassifier1, EClassifier eClassifier2) {
            if (eClassifier1 instanceof EClass && eClassifier2 instanceof EClass) {
                EClass eClass1 = (EClass)eClassifier1;
                EClass eClass2 = (EClass)eClassifier2;
                return eClass1.isSuperTypeOf(eClass2);
            }
            if (eClassifier1 instanceof EDataType && eClassifier2 instanceof EDataType) {
                EDataType eDataType1 = (EDataType)eClassifier1;
                EDataType eDataType2 = (EDataType)eClassifier2;
                Class<?> instanceClass1 = eDataType1.getInstanceClass();
                Class<?> instanceClass2 = eDataType2.getInstanceClass();
                if (instanceClass1 == null || instanceClass2 == null) {
                    return true;
                }
                return instanceClass1.isAssignableFrom(instanceClass2);
            }
            return false;
        }

        private boolean isSuperTypeOf(EDataType eDataType1, EDataType eDataType2) {
            Class<Object> instanceClass2;
            Class<Object> instanceClass1 = eDataType1.getInstanceClass();
            if (instanceClass1 == null && eDataType1 instanceof EEnum) {
                instanceClass1 = Enumerator.class;
            }
            if ((instanceClass2 = eDataType2.getInstanceClass()) == null && eDataType2 instanceof EEnum) {
                instanceClass2 = Enumerator.class;
            }
            if (instanceClass1 == null || instanceClass2 == null) {
                return true;
            }
            return instanceClass1.isAssignableFrom(instanceClass2) || instanceClass1.isAssignableFrom(EcoreUtil.wrapperClassFor(instanceClass2));
        }

        public boolean validateEntry(ExtendedMetaDataAnnotationValidator extendedMetaDataAnnotationValidator, Map.Entry<String, String> entry, DiagnosticChain diagnostics, Map<Object, Object> context) {
            boolean result = true;
            try {
                Method method = (Method)PropertySwitch.ENTRY_VALIDATORS.get(this.eClass);
                result = (Boolean)method.invoke((Object)this.extendedMetaData, this.eNamedElement, entry, diagnostics, context);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            return result;
        }

        public boolean validateEntryValueLiteral(ExtendedMetaDataAnnotationValidator extendedMetaDataAnnotationValidator, Map.Entry<String, String> entry, String literalValue, List<Object> referenceValues, DiagnosticChain diagnostics, Map<Object, Object> context) {
            boolean result = true;
            try {
                Method method = (Method)PropertySwitch.ENTRY_VALUE_LITERAL_VALIDATORS.get(this.eClass);
                result = (Boolean)method.invoke((Object)this.extendedMetaData, this.eNamedElement, entry, literalValue, referenceValues, diagnostics, context);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            return result;
        }

        public boolean validateEntryValue(ExtendedMetaDataAnnotationValidator extendedMetaDataAnnotationValidator, Map.Entry<String, String> entry, List<Object> values, DiagnosticChain diagnostics, Map<Object, Object> context) {
            boolean result = true;
            try {
                Method method = (Method)PropertySwitch.ENTRY_VALUE_VALIDATORS.get(this.eClass);
                result = (Boolean)method.invoke((Object)this.extendedMetaData, this.eNamedElement, entry, values, diagnostics, context);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class PropertySwitch
    extends EcoreSwitch<Void> {
        private static final EPackage EXTENDED_META_DATA_PACKAGE;
        private static final Map<EStructuralFeature, Method> GETTERS;
        private static final Map<EStructuralFeature, Method> SETTERS;
        private static final Map<EClass, Method> ENTRY_VALIDATORS;
        private static final Map<EClass, Method> ENTRY_VALUE_LITERAL_VALIDATORS;
        private static final Map<EClass, Method> ENTRY_VALUE_VALIDATORS;

        static {
            GETTERS = new HashMap<EStructuralFeature, Method>();
            SETTERS = new HashMap<EStructuralFeature, Method>();
            ENTRY_VALIDATORS = new HashMap<EClass, Method>();
            ENTRY_VALUE_LITERAL_VALIDATORS = new HashMap<EClass, Method>();
            ENTRY_VALUE_VALIDATORS = new HashMap<EClass, Method>();
            EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage("http:///org/eclipse/emf/ecore/util/ExtendedMetaData");
            if (ePackage == null) {
                ePackage = ExtendedMetaDataAnnotationValidator.loadEPackage(String.valueOf(EcorePlugin.INSTANCE.getBaseURL().toString()) + "model/ExtendedMetaData.ecore");
            }
            EXTENDED_META_DATA_PACKAGE = ePackage;
            if (ePackage != null) {
                final EClassifier xmlPatternDataType = ePackage.getEClassifier("Pattern");
                EObjectValidator eObjectValidator = new EObjectValidator(){

                    @Override
                    public boolean validate(EDataType eDataType, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
                        boolean result;
                        block3: {
                            result = super.validate(eDataType, value, diagnostics, context);
                            if (eDataType == xmlPatternDataType && result && value != null) {
                                try {
                                    XMLTypeUtil.createPatternMatcher((String)value);
                                }
                                catch (RuntimeException exception) {
                                    result = false;
                                    if (diagnostics == null) break block3;
                                    diagnostics.add(this.createDiagnostic(4, ExtendedMetaDataAnnotationValidator.DIAGNOSTIC_SOURCE, 0, "_UI_BadXMLPattern_diagnostic", new Object[]{1.getValueLabel(eDataType, value, context), exception.getLocalizedMessage()}, new Object[]{value, eDataType}, context));
                                }
                            }
                        }
                        return result;
                    }
                };
                EValidator.Registry.INSTANCE.put(ePackage, eObjectValidator);
                ePackage.setEFactoryInstance(new EFactoryImpl(){

                    protected EObject basicCreate(EClass eClass) {
                        ModelObject result = new ModelObject();
                        result.eSetClass(eClass);
                        return result;
                    }
                });
                Method[] methods = SpecializedExtendedMetaData.class.getMethods();
                for (EClassifier eClassifier : ePackage.getEClassifiers()) {
                    if (!(eClassifier instanceof EClass)) continue;
                    EClass eClass = (EClass)eClassifier;
                    if (!eClass.isAbstract()) {
                        ENTRY_VALIDATORS.put(eClass, PropertySwitch.getMethod(methods, eClass, "validate" + eClass.getName() + "Entry", 4));
                        ENTRY_VALUE_LITERAL_VALIDATORS.put(eClass, PropertySwitch.getMethod(methods, eClass, "validate" + eClass.getName() + "EntryValueLiteral", 6));
                        ENTRY_VALUE_VALIDATORS.put(eClass, PropertySwitch.getMethod(methods, eClass, "validate" + eClass.getName() + "EntryValue", 5));
                    }
                    for (EStructuralFeature eStructuralFeature : eClass.getEAllStructuralFeatures()) {
                        EClass eContainingClass = eStructuralFeature.getEContainingClass();
                        String accessor = EcoreUtil.getAnnotation(eStructuralFeature, "Reflection", "accessor");
                        GETTERS.put(eStructuralFeature, PropertySwitch.getMethod(methods, eContainingClass, String.valueOf("boolean".equals(eStructuralFeature.getEType().getInstanceClassName()) ? "is" : "get") + accessor, 1));
                        SETTERS.put(eStructuralFeature, PropertySwitch.getMethod(methods, eContainingClass, "set" + accessor, 2));
                    }
                }
            }
        }

        private PropertySwitch() {
        }

        private static Method getMethod(Method[] methods, EClass eClass, String expectedName, int expectedCount) {
            Method[] methodArray = methods;
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                String name = method.getName();
                if (name.equals(expectedName) && method.getParameterTypes().length == expectedCount && method.getParameterTypes()[0].getName().endsWith(eClass.getName())) {
                    return method;
                }
                ++n2;
            }
            throw new IllegalStateException();
        }

        protected abstract void addFeatures(EClass var1);

        @Override
        public Void caseEPackage(EPackage object) {
            if (EXTENDED_META_DATA_PACKAGE != null) {
                this.addFeatures((EClass)EXTENDED_META_DATA_PACKAGE.getEClassifier("Package"));
            }
            return null;
        }

        @Override
        public Void caseEClass(EClass eClass) {
            if (EXTENDED_META_DATA_PACKAGE != null) {
                this.addFeatures((EClass)EXTENDED_META_DATA_PACKAGE.getEClassifier("Class"));
            }
            return null;
        }

        @Override
        public Void caseEDataType(EDataType eDataType) {
            if (EXTENDED_META_DATA_PACKAGE != null) {
                this.addFeatures((EClass)EXTENDED_META_DATA_PACKAGE.getEClassifier("DataType"));
            }
            return null;
        }

        @Override
        public Void caseEStructuralFeature(EStructuralFeature eStructuralFeature) {
            if (EXTENDED_META_DATA_PACKAGE != null) {
                this.addFeatures((EClass)EXTENDED_META_DATA_PACKAGE.getEClassifier("StructuralFeature"));
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SpecializedExtendedMetaData
    extends BasicExtendedMetaData {
        private static final Map<ResourceSet, SpecializedExtendedMetaData> EXTENDED_META_DATA_CACHE = new WeakHashMap<ResourceSet, SpecializedExtendedMetaData>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static SpecializedExtendedMetaData getExtendedMetaData(EObject eObject) {
            Map<ResourceSet, SpecializedExtendedMetaData> map = EXTENDED_META_DATA_CACHE;
            synchronized (map) {
                SpecializedExtendedMetaData specializedExtendedMetaData;
                ResourceSet resourceSet = null;
                Resource resource = eObject.eResource();
                if (resource != null) {
                    resourceSet = resource.getResourceSet();
                }
                if ((specializedExtendedMetaData = EXTENDED_META_DATA_CACHE.get(resourceSet)) == null) {
                    if (resourceSet == null) {
                        EPackageRegistryImpl registry = new EPackageRegistryImpl(EPackage.Registry.INSTANCE);
                        specializedExtendedMetaData = new SpecializedExtendedMetaData(registry);
                    } else {
                        final ResourceSet theResourceSet = resourceSet;
                        EPackageRegistryImpl ePackageRegistry = new EPackageRegistryImpl(resourceSet.getPackageRegistry()){
                            private static final long serialVersionUID = 1L;

                            public EPackage getEPackage(String nsURI) {
                                EPackage result = super.getEPackage(nsURI);
                                if (result == null) {
                                    TreeIterator<Notifier> allContents = theResourceSet.getAllContents();
                                    while (allContents.hasNext()) {
                                        Notifier content = (Notifier)allContents.next();
                                        if (content instanceof EPackage) {
                                            EPackage ePackage = (EPackage)content;
                                            String ePackageNsURI = ePackage.getNsURI();
                                            if (!(ePackageNsURI == null ? nsURI == null : ePackageNsURI.equals(nsURI))) continue;
                                            return ePackage;
                                        }
                                        if (!(content instanceof EObject)) continue;
                                        allContents.prune();
                                    }
                                }
                                return result;
                            }
                        };
                        specializedExtendedMetaData = new SpecializedExtendedMetaData(ePackageRegistry);
                    }
                    EXTENDED_META_DATA_CACHE.put(resourceSet, specializedExtendedMetaData);
                }
                return specializedExtendedMetaData;
            }
        }

        public SpecializedExtendedMetaData(EPackage.Registry registry) {
            super(registry);
            this.extendedMetaDataHolderCache = new HashMap<EModelElement, Object>(){
                private static final long serialVersionUID = 1L;

                @Override
                public Object put(EModelElement key, Object value) {
                    return null;
                }
            };
            this.putPackage("http://www.w3.org/2001/XMLSchema", this.getPackage("http://www.eclipse.org/emf/2003/XMLType"));
        }

        @Override
        protected boolean isFeatureKindSpecific() {
            return false;
        }

        @Override
        protected boolean isFeatureNamespaceMatchingLax() {
            return true;
        }

        public void setDocumentRoot(EClass eClass, boolean documentRoot) {
            if (documentRoot) {
                EReference xsiSchemaLocationMapFeature;
                this.setDocumentRoot(eClass);
                EReference xmlnsPrefixMapFeature = this.getXMLNSPrefixMapFeature(eClass);
                if (xmlnsPrefixMapFeature == null) {
                    eClass.getEStructuralFeatures().add(EcoreUtil.copy(XMLTypePackage.Literals.XML_TYPE_DOCUMENT_ROOT__XMLNS_PREFIX_MAP));
                }
                if ((xsiSchemaLocationMapFeature = this.getXSISchemaLocationMapFeature(eClass)) == null) {
                    eClass.getEStructuralFeatures().add(EcoreUtil.copy(XMLTypePackage.Literals.XML_TYPE_DOCUMENT_ROOT__XSI_SCHEMA_LOCATION));
                }
            } else {
                EAnnotation eAnnotation = this.getAnnotation(eClass, false);
                if (eAnnotation != null) {
                    eAnnotation.getDetails().removeKey("name");
                }
            }
        }

        @Override
        public void setContentKind(EClass eClass, int kind) {
            EStructuralFeature simpleFeature;
            super.setContentKind(eClass, kind);
            if (kind == 3) {
                EAttribute mixedFeature = this.getMixedFeature(eClass);
                if (mixedFeature == null) {
                    eClass.getEStructuralFeatures().add(EcoreUtil.copy(XMLTypePackage.Literals.XML_TYPE_DOCUMENT_ROOT__MIXED));
                }
                for (EStructuralFeature eStructuralFeature : this.getElements(eClass)) {
                    eStructuralFeature.setUpperBound(-2);
                    eStructuralFeature.setDerived(true);
                    eStructuralFeature.setVolatile(true);
                    eStructuralFeature.setTransient(true);
                }
            } else if (kind == 2 && (simpleFeature = this.getSimpleFeature(eClass)) == null) {
                simpleFeature = EcoreFactory.eINSTANCE.createEAttribute();
                simpleFeature.setName("simple");
                simpleFeature.setEType(XMLTypePackage.Literals.STRING);
                this.setFeatureKind(simpleFeature, 1);
                eClass.getEStructuralFeatures().add(simpleFeature);
            }
        }

        @Override
        public void setFeatureKind(EStructuralFeature eStructuralFeature, int kind) {
            super.setFeatureKind(eStructuralFeature, kind);
            if ((kind == 5 || kind == 3 || kind == 6) && eStructuralFeature instanceof EAttribute) {
                eStructuralFeature.setEType(EcorePackage.Literals.EFEATURE_MAP_ENTRY);
            }
        }

        @Override
        public void setNamespace(EStructuralFeature eStructuralFeature, String namespace) {
            super.setNamespace(eStructuralFeature, "".equals(namespace) ? null : namespace);
        }

        @Override
        public void setItemType(EDataType eDataType, EDataType itemType) {
            super.setItemType(eDataType, itemType);
            if (itemType != null) {
                super.setBaseType(eDataType, null);
                super.setMemberTypes(eDataType, Collections.<EDataType>emptyList());
            }
        }

        @Override
        public void setBaseType(EDataType eDataType, EDataType baseType) {
            super.setBaseType(eDataType, baseType);
            if (baseType != null) {
                super.setItemType(eDataType, null);
                super.setMemberTypes(eDataType, Collections.<EDataType>emptyList());
            }
        }

        @Override
        public void setMemberTypes(EDataType eDataType, List<EDataType> memberTypes) {
            super.setMemberTypes(eDataType, memberTypes);
            if (!memberTypes.isEmpty()) {
                super.setBaseType(eDataType, null);
                super.setItemType(eDataType, null);
            }
        }

        @Override
        public void setMinExclusiveFacet(EDataType eDataType, String literal) {
            super.setMinExclusiveFacet(eDataType, literal);
            if (literal != null) {
                super.setMinInclusiveFacet(eDataType, null);
            }
        }

        @Override
        public void setMinInclusiveFacet(EDataType eDataType, String literal) {
            super.setMinInclusiveFacet(eDataType, literal);
            if (literal != null) {
                super.setMinExclusiveFacet(eDataType, literal);
            }
        }

        @Override
        public void setMaxExclusiveFacet(EDataType eDataType, String literal) {
            super.setMaxExclusiveFacet(eDataType, literal);
            if (literal != null) {
                super.setMaxInclusiveFacet(eDataType, null);
            }
        }

        @Override
        public void setMaxInclusiveFacet(EDataType eDataType, String literal) {
            super.setMaxInclusiveFacet(eDataType, literal);
            if (literal != null) {
                super.setMaxExclusiveFacet(eDataType, literal);
            }
        }

        @Override
        public void setLengthFacet(EDataType eDataType, int length) {
            super.setLengthFacet(eDataType, length);
            if (length != -1) {
                super.setMinLengthFacet(eDataType, -1);
                super.setMaxLengthFacet(eDataType, -1);
            }
        }

        @Override
        public void setMinLengthFacet(EDataType eDataType, int length) {
            super.setMinLengthFacet(eDataType, length);
            if (length != -1) {
                super.setLengthFacet(eDataType, -1);
            }
        }

        @Override
        public void setMaxLengthFacet(EDataType eDataType, int length) {
            super.setMaxLengthFacet(eDataType, length);
            if (length != -1) {
                super.setLengthFacet(eDataType, -1);
            }
        }

        protected ExtendedMetaDataAnnotationValidator getValidator(Map<Object, Object> context) {
            return (ExtendedMetaDataAnnotationValidator)context.get("EXTENDED_META_DATA_ANNOTATION_VALIDATOR");
        }

        protected BasicDiagnostic createDiagnostic(int severity, int code, String message, Object ... data) {
            return new BasicDiagnostic(severity, ExtendedMetaDataAnnotationValidator.DIAGNOSTIC_SOURCE, code, message, data);
        }

        protected void reportIgnoredEntry(Map.Entry<String, String> entry, DiagnosticChain diagnostics, String key, Object ... substitutions) {
            diagnostics.add(this.createDiagnostic(2, 12, EcorePlugin.INSTANCE.getString(key, substitutions), entry, EcorePackage.Literals.ESTRING_TO_STRING_MAP_ENTRY__KEY));
        }

        protected void reportBadValue(Object value, DiagnosticChain diagnostics, int severity, String key, Object ... substitutions) {
            diagnostics.add(this.createDiagnostic(severity, 5, EcorePlugin.INSTANCE.getString(key, substitutions), value));
        }

        public boolean validateDataTypeEntry(EDataType eDataType, Map.Entry<String, String> entry, DiagnosticChain diagnostics, Map<Object, Object> context) {
            String key = entry.getKey();
            Class<Object> instanceClass = eDataType.getInstanceClass();
            if (instanceClass == null && eDataType instanceof EEnum) {
                instanceClass = Enumerator.class;
            }
            if ("totalDigits".equals(key) || "fractionDigits".equals(key)) {
                if (instanceClass != BigDecimal.class) {
                    if (diagnostics != null) {
                        this.reportIgnoredEntry(entry, diagnostics, "_UI_ExtendeMetaDataAnnotationDetailNotBigDecimal_diagnostic", key);
                    }
                    return false;
                }
                return true;
            }
            if ("length".equals(key) || "maxLength".equals(key) || "minLength".equals(key)) {
                boolean result = this.hasLength(instanceClass);
                if (!result && diagnostics != null) {
                    this.reportIgnoredEntry(entry, diagnostics, "_UI_ExtendeMetaDataAnnotationDetailNotHasLength_diagnostic", key);
                }
                return result;
            }
            if ("itemType".equals(key)) {
                boolean result;
                boolean bl = result = instanceClass == List.class;
                if (!result && diagnostics != null) {
                    this.reportIgnoredEntry(entry, diagnostics, "_UI_ExtendeMetaDataAnnotationDetailNotList_diagnostic", key);
                }
                return result;
            }
            if ("baseType".equals(key)) {
                boolean result;
                boolean bl = result = !(eDataType instanceof EEnum);
                if (!result && diagnostics != null) {
                    this.reportIgnoredEntry(entry, diagnostics, "_UI_ExtendeMetaDataAnnotationDetailNotRestrictEnum_diagnostic", key);
                }
                return result;
            }
            if ("memberTypes".equals(key)) {
                boolean result;
                boolean bl = result = !(eDataType instanceof EEnum);
                if (!result && diagnostics != null) {
                    this.reportIgnoredEntry(entry, diagnostics, "_UI_ExtendeMetaDataAnnotationDetailNotRestrictEnum_diagnostic", key);
                }
                return result;
            }
            if ("maxInclusive".equals(key) || "maxExclusive".equals(key) || "minInclusive".equals(key) || "minExclusive".equals(key)) {
                boolean result;
                boolean bl = result = instanceClass == null || this.isComparable(instanceClass);
                if (!result && diagnostics != null) {
                    this.reportIgnoredEntry(entry, diagnostics, "_UI_ExtendeMetaDataAnnotationDetailNotComparable_diagnostic", key);
                } else if (eDataType instanceof EEnum && !(result = false) && diagnostics != null) {
                    this.reportIgnoredEntry(entry, diagnostics, "_UI_ExtendeMetaDataAnnotationDetailNotRestrictEnum_diagnostic", key);
                }
                return result;
            }
            if ("enumeration".equals(key)) {
                boolean result;
                boolean bl = result = !(eDataType instanceof EEnum);
                if (!result && diagnostics != null) {
                    this.reportIgnoredEntry(entry, diagnostics, "_UI_ExtendeMetaDataAnnotationDetailNotRestrictEnum_diagnostic", key);
                }
                return result;
            }
            if ("pattern".equals(key)) {
                boolean result;
                boolean bl = result = !(eDataType instanceof EEnum);
                if (!result && diagnostics != null) {
                    this.reportIgnoredEntry(entry, diagnostics, "_UI_ExtendeMetaDataAnnotationDetailNotRestrictEnum_diagnostic", key);
                }
                return result;
            }
            if ("whiteSpace".equals(key)) {
                boolean result;
                boolean bl = result = !(eDataType instanceof EEnum);
                if (!result && diagnostics != null) {
                    this.reportIgnoredEntry(entry, diagnostics, "_UI_ExtendeMetaDataAnnotationDetailNotRestrictEnum_diagnostic", key);
                }
                return result;
            }
            return true;
        }

        private boolean isComparable(Class<?> instanceClass) {
            if (instanceClass == null) {
                return true;
            }
            return instanceClass == Enumerator.class || Comparable.class.isAssignableFrom(EcoreUtil.wrapperClassFor(instanceClass));
        }

        private boolean hasLength(Class<?> instanceClass) {
            if (instanceClass == null) {
                return true;
            }
            return instanceClass == String.class || Collection.class.isAssignableFrom(instanceClass) || instanceClass.isArray();
        }

        public boolean validatePackageEntry(EPackage ePackage, Map.Entry<String, String> entry, DiagnosticChain diagnostics, Map<Object, Object> context) {
            return true;
        }

        public boolean validateClassEntry(EClass eClass, Map.Entry<String, String> entry, DiagnosticChain diagnostics, Map<Object, Object> context) {
            return true;
        }

        public boolean validateStructuralFeatureEntry(EStructuralFeature eStructuralFeature, Map.Entry<String, String> entry, DiagnosticChain diagnostics, Map<Object, Object> context) {
            String key = entry.getKey();
            if ("affiliation".equals(key)) {
                boolean result = true;
                int featureKind = this.getFeatureKind(eStructuralFeature);
                if (featureKind != 4 || eStructuralFeature.getEContainingClass() == null || !this.isDocumentRoot(eStructuralFeature.getEContainingClass())) {
                    result = false;
                }
                if (!result && diagnostics != null) {
                    this.reportIgnoredEntry(entry, diagnostics, "_UI_ExtendeMetaDataAnnotationDetailNotGlobalElement_diagnostic", key);
                }
                return result;
            }
            if ("processing".equals(key)) {
                boolean result = true;
                int featureKind = this.getFeatureKind(eStructuralFeature);
                if (featureKind != 3 && featureKind != 5) {
                    result = false;
                }
                if (!result && diagnostics != null) {
                    this.reportIgnoredEntry(entry, diagnostics, "_UI_ExtendeMetaDataAnnotationDetailNotWildcard_diagnostic", key);
                }
                return result;
            }
            if ("wildcards".equals(key)) {
                boolean result = true;
                int featureKind = this.getFeatureKind(eStructuralFeature);
                if (featureKind != 3 && featureKind != 5) {
                    result = false;
                }
                if (!result && diagnostics != null) {
                    this.reportIgnoredEntry(entry, diagnostics, "_UI_ExtendeMetaDataAnnotationDetailNotWildcard_diagnostic", key);
                }
                return result;
            }
            if ("namespace".equals(key)) {
                boolean result = true;
                int featureKind = this.getFeatureKind(eStructuralFeature);
                if (featureKind != 4 && featureKind != 2 && featureKind != 6) {
                    result = false;
                }
                if (!result && diagnostics != null) {
                    this.reportIgnoredEntry(entry, diagnostics, "_UI_ExtendeMetaDataAnnotationDetailNotElementAttributeOrGroup_diagnostic", key);
                }
                return result;
            }
            return true;
        }

        public boolean validateDataTypeEntryValueLiteral(EDataType eDataType, Map.Entry<String, String> entry, String literalValue, List<Object> values, DiagnosticChain diagnostics, Map<Object, Object> context) {
            String key = entry.getKey();
            if ("baseType".equals(key) || "itemType".equals(key) || "memberTypes".equals(key)) {
                EClassifier eClassifier = this.getEClassifier(eDataType.getEPackage(), literalValue);
                if (eClassifier == null) {
                    if (diagnostics != null) {
                        this.reportBadValue(literalValue, diagnostics, 2, "_UI_ExtendeMetaDataAnnotationDetailNotTypeResolved_diagnostic", literalValue);
                    }
                    return false;
                }
                if (!(eClassifier instanceof EDataType)) {
                    if (diagnostics != null) {
                        this.reportBadValue(literalValue, diagnostics, 2, "_UI_ExtendeMetaDataAnnotationDetailNotTypeResolvedCorrectly_diagnostic", literalValue);
                    }
                    return false;
                }
                values.add(eClassifier);
                return true;
            }
            return true;
        }

        public boolean validatePackageEntryValueLiteral(EPackage ePackage, Map.Entry<String, String> entry, String literalValue, List<Object> values, DiagnosticChain diagnostics, Map<Object, Object> context) {
            return true;
        }

        public boolean validateClassEntryValueLiteral(EClass eClass, Map.Entry<String, String> entry, String literalValue, List<Object> values, DiagnosticChain diagnostics, Map<Object, Object> context) {
            return true;
        }

        public boolean validateStructuralFeatureEntryValueLiteral(EStructuralFeature eStructuralFeature, Map.Entry<String, String> entry, String literalValue, List<Object> values, DiagnosticChain diagnostics, Map<Object, Object> context) {
            String key = entry.getKey();
            if ("group".equals(key)) {
                EStructuralFeature group = this.getGroup(eStructuralFeature);
                if (group == null) {
                    this.reportBadValue(literalValue, diagnostics, 2, "_UI_ExtendeMetaDataAnnotationDetailNotGroupResolved_diagnostic", literalValue);
                    return false;
                }
                values.add(group);
                return true;
            }
            if ("affiliation".equals(key)) {
                EStructuralFeature affiliation = this.getAffiliation(eStructuralFeature);
                if (affiliation == null) {
                    this.reportBadValue(literalValue, diagnostics, 2, "_UI_ExtendeMetaDataAnnotationDetailNotAffiliationResolved_diagnostic", literalValue);
                    return false;
                }
                values.add(affiliation);
                return true;
            }
            return true;
        }

        public boolean validateDataTypeEntryValue(EDataType eDataType, Map.Entry<String, String> entry, List<Object> values, DiagnosticChain diagnostics, Map<Object, Object> context) {
            String key = entry.getKey();
            boolean result = true;
            if ("baseType".equals(key) || "itemType".equals(key) || "memberTypes".equals(key)) {
                for (Object value : values) {
                    EDataType otherEDataType = (EDataType)value;
                    Set<EDataType> inheritedTypes = this.getInheritedTypes(otherEDataType);
                    if (!inheritedTypes.contains(eDataType)) continue;
                    result = false;
                    if (diagnostics == null) break;
                    this.reportBadValue(inheritedTypes, diagnostics, 4, "_UI_ExtendeMetaDataAnnotationDetailTypeCircular_diagnostic", this.getQualifiedName(this.getNamespace(eDataType), otherEDataType));
                }
            }
            return result;
        }

        protected Set<EDataType> getInheritedTypes(EDataType eDataType) {
            LinkedHashSet<EDataType> typesToVisit = new LinkedHashSet<EDataType>();
            LinkedHashSet<EDataType> result = new LinkedHashSet<EDataType>();
            typesToVisit.add(eDataType);
            do {
                EDataType itemType;
                Iterator it = typesToVisit.iterator();
                EDataType dataType = (EDataType)it.next();
                it.remove();
                if (!result.add(dataType)) continue;
                EDataType baseType = this.getBaseType(dataType);
                if (baseType != null) {
                    typesToVisit.add(baseType);
                }
                if ((itemType = this.getItemType(dataType)) != null) {
                    typesToVisit.add(itemType);
                }
                typesToVisit.addAll(this.getMemberTypes(dataType));
            } while (!typesToVisit.isEmpty());
            return result;
        }

        public boolean validatePackageEntryValue(EPackage ePackage, Map.Entry<String, String> entry, List<Object> values, DiagnosticChain diagnostics, Map<Object, Object> context) {
            return true;
        }

        public boolean validateClassEntryValue(EClass eClass, Map.Entry<String, String> entry, List<Object> values, DiagnosticChain diagnostics, Map<Object, Object> context) {
            return true;
        }

        public boolean validateStructuralFeatureEntryValue(EStructuralFeature eStructuralFeature, Map.Entry<String, String> entry, List<Object> values, DiagnosticChain diagnostics, Map<Object, Object> context) {
            String key = entry.getKey();
            if ("group".equals(key)) {
                EStructuralFeature group = (EStructuralFeature)values.get(0);
                Set<EStructuralFeature> groups = this.getAffiliations(group);
                if (groups.contains(eStructuralFeature)) {
                    this.reportBadValue(groups, diagnostics, 4, "_UI_ExtendeMetaDataAnnotationDetailGroupCircular_diagnostic", this.getQualifiedName(this.getPackageNamespace(group), group));
                    return false;
                }
                return true;
            }
            if ("affiliation".equals(key)) {
                EStructuralFeature affiliation = (EStructuralFeature)values.get(0);
                Set<EStructuralFeature> affiliations = this.getAffiliations(affiliation);
                if (affiliations.contains(eStructuralFeature)) {
                    this.reportBadValue(affiliations, diagnostics, 4, "_UI_ExtendeMetaDataAnnotationDetailAffiliationCircular_diagnostic", this.getQualifiedName(this.getPackageNamespace(affiliation), affiliation));
                    return false;
                }
                return true;
            }
            return true;
        }

        protected Set<EStructuralFeature> getAffiliations(EStructuralFeature eStructuralFeature) {
            LinkedHashSet<EStructuralFeature> result = new LinkedHashSet<EStructuralFeature>();
            EStructuralFeature affiliation = eStructuralFeature;
            while (affiliation != null) {
                if (!result.add(affiliation)) break;
                affiliation = this.getAffiliation(affiliation);
            }
            return result;
        }

        protected Set<EStructuralFeature> getGroups(EStructuralFeature eStructuralFeature) {
            LinkedHashSet<EStructuralFeature> result = new LinkedHashSet<EStructuralFeature>();
            EStructuralFeature group = eStructuralFeature;
            while (group != null) {
                if (!result.add(group)) break;
                group = this.getGroup(group);
            }
            return result;
        }
    }
}

