/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ingres.internal.catalog;

import java.lang.ref.SoftReference;
import java.sql.Connection;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.enablement.ingres.internal.loaders.IngresTableConstraintDefinitionLoader;
import org.eclipse.datatools.modelbase.sql.constraints.impl.CheckConstraintImpl;
import org.eclipse.datatools.modelbase.sql.expressions.SQLExpressionsFactory;
import org.eclipse.datatools.modelbase.sql.expressions.SearchCondition;
import org.eclipse.datatools.modelbase.sql.expressions.SearchConditionDefault;
import org.eclipse.datatools.modelbase.sql.schema.Database;

public class IngresCatalogCheckConstraint
extends CheckConstraintImpl
implements ICatalogObject {
    private final Object SEARCHCONDITION_LOCK = new Object();
    private Boolean searchConditionLoaded = Boolean.FALSE;
    private SoftReference constraintDefinitionLoaderRef;

    public Database getCatalogDatabase() {
        return this.getBaseTable().getSchema().getCatalog().getDatabase();
    }

    public Connection getConnection() {
        Database db = this.getCatalogDatabase();
        if (db instanceof ICatalogObject) {
            return ((ICatalogObject)db).getConnection();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        Object object = this.SEARCHCONDITION_LOCK;
        synchronized (object) {
            if (this.searchConditionLoaded.booleanValue()) {
                this.searchConditionLoaded = Boolean.FALSE;
            }
        }
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SearchCondition getSearchCondition() {
        Object object = this.SEARCHCONDITION_LOCK;
        synchronized (object) {
            if (!this.searchConditionLoaded.booleanValue()) {
                this.loadSearchCondition();
            }
        }
        return super.getSearchCondition();
    }

    protected final IngresTableConstraintDefinitionLoader getConstraintDefinitionLoader() {
        if (this.constraintDefinitionLoaderRef == null || this.constraintDefinitionLoaderRef.get() == null) {
            this.constraintDefinitionLoaderRef = new SoftReference<IngresTableConstraintDefinitionLoader>(this.createConstraintDefinitionLoader());
        }
        return (IngresTableConstraintDefinitionLoader)((Object)this.constraintDefinitionLoaderRef.get());
    }

    protected IngresTableConstraintDefinitionLoader createConstraintDefinitionLoader() {
        return new IngresTableConstraintDefinitionLoader(this);
    }

    private void loadSearchCondition() {
        boolean deliver = this.eDeliver();
        try {
            try {
                this.eSetDeliver(false);
                SearchConditionDefault loadedSearchCondition = SQLExpressionsFactory.eINSTANCE.createSearchConditionDefault();
                this.getConstraintDefinitionLoader().loadCheckConstraintDefinition(this.getBaseTable().getSchema().getName(), this.getBaseTable().getName(), this.getName(), (SearchCondition)loadedSearchCondition);
                this.setSearchCondition((SearchCondition)loadedSearchCondition);
                this.searchConditionLoaded = Boolean.TRUE;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.eSetDeliver(deliver);
            }
        }
        finally {
            this.eSetDeliver(deliver);
        }
    }
}

