/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dartboard.util;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.DialogPage;

public class StatusUtil {
    private StatusUtil() {
    }

    public static IStatus newStatus(int severity, String message, Throwable exception) {
        String statusMessage = message;
        if (message == null || message.trim().isEmpty()) {
            if (exception == null) {
                throw new IllegalArgumentException();
            }
            statusMessage = exception.getMessage() == null ? exception.toString() : exception.getMessage();
        }
        return new Status(severity, "org.eclipse.dartboard", severity, statusMessage, exception);
    }

    public static IStatus createError(Throwable exception) {
        return StatusUtil.newStatus(4, "", exception);
    }

    public static IStatus createWarning(Throwable exception) {
        return StatusUtil.newStatus(2, "", exception);
    }

    public static IStatus createError(String message, Throwable exception) {
        return StatusUtil.newStatus(4, message, exception);
    }

    public static IStatus createWarning(String message, Throwable exception) {
        return StatusUtil.newStatus(2, message, exception);
    }

    public static IStatus newStatus(int severity, String message) {
        return new Status(severity, "org.eclipse.dartboard", message);
    }

    public static IStatus createError(String message) {
        return StatusUtil.newStatus(4, message);
    }

    public static IStatus createWarning(String message) {
        return StatusUtil.newStatus(2, message);
    }

    public static void throwCoreException(String message) throws CoreException {
        throw new CoreException(StatusUtil.createError(message));
    }

    public static void applyToStatusLine(DialogPage page, IStatus status) {
        String message = status.getMessage();
        switch (status.getSeverity()) {
            case 0: {
                page.setMessage(message, 0);
                page.setErrorMessage(null);
                break;
            }
            case 2: {
                page.setMessage(message, 2);
                page.setErrorMessage(null);
                break;
            }
            case 1: {
                page.setMessage(message, 1);
                page.setErrorMessage(null);
                break;
            }
            default: {
                if (message.isEmpty()) {
                    message = null;
                }
                page.setMessage(null);
                page.setErrorMessage(message);
            }
        }
    }
}

