/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.behavior.validation;

import org.eclipse.comma.behavior.behavior.AbstractBehavior;
import org.eclipse.comma.behavior.behavior.BehaviorPackage;
import org.eclipse.comma.behavior.behavior.ConditionedAbsenceOfEvent;
import org.eclipse.comma.behavior.behavior.GroupTimeConstraint;
import org.eclipse.comma.behavior.behavior.PeriodicEvent;
import org.eclipse.comma.behavior.behavior.TimeConstraintExpression;
import org.eclipse.comma.behavior.behavior.TimeInterval;
import org.eclipse.comma.behavior.validation.TransitionsValidator;
import org.eclipse.comma.expressions.expression.Expression;
import org.eclipse.comma.expressions.expression.ExpressionConstantReal;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.validation.Check;

public class TimeConstraintsValidator
extends TransitionsValidator {
    public static final String GROUP_CONSTRAINT_MISING_END = "group_constraint_end";
    public static final String TIME_CONSTRAINT_DUPLICATE = "time_constraint_duplicated";

    @Check
    public void checkTypingPeriodicEvent(PeriodicEvent evt) {
        Expression _jitter;
        boolean _tripleNotEquals_1;
        boolean _tripleNotEquals;
        Expression _period = evt.getPeriod();
        boolean bl = _tripleNotEquals = _period != null;
        if (_tripleNotEquals) {
            boolean _not;
            Expression _period_1 = evt.getPeriod();
            boolean bl2 = _not = !(_period_1 instanceof ExpressionConstantReal);
            if (_not) {
                this.error("The value of period must be a positive real constant.", (EStructuralFeature)BehaviorPackage.Literals.PERIODIC_EVENT__PERIOD);
            }
        }
        boolean bl3 = _tripleNotEquals_1 = (_jitter = evt.getJitter()) != null;
        if (_tripleNotEquals_1) {
            boolean _not_1;
            Expression _jitter_1 = evt.getJitter();
            boolean bl4 = _not_1 = !(_jitter_1 instanceof ExpressionConstantReal);
            if (_not_1) {
                this.error("The value of jitter must be a positive real constant.", (EStructuralFeature)BehaviorPackage.Literals.PERIODIC_EVENT__JITTER);
            }
        }
    }

    @Check
    public void checkLowerBoundOfIntervalToBeSmallerThanHigherBound(TimeInterval timeInterval) {
        Expression _end;
        double end;
        Expression _begin;
        double begin;
        if (timeInterval.getBegin() == null || timeInterval.getEnd() == null) {
            return;
        }
        if (timeInterval.getBegin() instanceof ExpressionConstantReal && timeInterval.getEnd() instanceof ExpressionConstantReal && (begin = ((ExpressionConstantReal)(_begin = timeInterval.getBegin())).getValue()) >= (end = ((ExpressionConstantReal)(_end = timeInterval.getEnd())).getValue())) {
            this.error("Lower bound should be less than the upper bound.", timeInterval, (EStructuralFeature)BehaviorPackage.Literals.TIME_INTERVAL__BEGIN);
        }
    }

    @Check
    public void checkTimeInterval(TimeInterval timeInterval) {
        Expression _end;
        boolean _tripleNotEquals_1;
        boolean _tripleNotEquals;
        Expression _begin = timeInterval.getBegin();
        boolean bl = _tripleNotEquals = _begin != null;
        if (_tripleNotEquals) {
            boolean _not;
            Expression _begin_1 = timeInterval.getBegin();
            boolean bl2 = _not = !(_begin_1 instanceof ExpressionConstantReal);
            if (_not) {
                this.error("The begin of the interval must be a positive real constant.", (EStructuralFeature)BehaviorPackage.Literals.TIME_INTERVAL__BEGIN);
            }
        }
        boolean bl3 = _tripleNotEquals_1 = (_end = timeInterval.getEnd()) != null;
        if (_tripleNotEquals_1) {
            boolean _not_1;
            Expression _end_1 = timeInterval.getEnd();
            boolean bl4 = _not_1 = !(_end_1 instanceof ExpressionConstantReal);
            if (_not_1) {
                this.error("The end of the interval must be a positive real constant.", (EStructuralFeature)BehaviorPackage.Literals.TIME_INTERVAL__END);
            }
        }
    }

    @Check
    public void checkIntervalInGroupConstraintMissingEventTrigger(GroupTimeConstraint gt) {
        TimeConstraintExpression _first = gt.getFirst();
        if (_first instanceof ConditionedAbsenceOfEvent) {
            boolean _tripleNotEquals;
            TimeConstraintExpression _first_1 = gt.getFirst();
            TimeInterval i = ((ConditionedAbsenceOfEvent)_first_1).getInterval();
            Expression _begin = i.getBegin();
            boolean bl = _tripleNotEquals = _begin != null;
            if (_tripleNotEquals) {
                this.error("The interval used in this scenario must be in the form [.. RealConst ms].", gt.getFirst(), (EStructuralFeature)BehaviorPackage.Literals.CONDITIONED_ABSENCE_OF_EVENT__INTERVAL, GROUP_CONSTRAINT_MISING_END, null);
            }
        }
    }

    @Check
    public void checkUniqueTimeConstraintsNames(AbstractBehavior spec) {
        this.checkForNameDuplications((Iterable)spec.getTimeConstraintsBlock().getTimeConstraints(), "time constraints", TIME_CONSTRAINT_DUPLICATE, new String[]{"constraint"});
    }
}

