/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.monitoring.lib.constraints;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.comma.monitoring.lib.constraints.CConstraintValue;
import org.eclipse.comma.monitoring.lib.constraints.CFormula;
import org.eclipse.comma.monitoring.lib.constraints.CRuleError;
import org.eclipse.comma.monitoring.lib.constraints.CRuleObserver;
import org.eclipse.comma.monitoring.lib.messages.CObservedMessage;
import org.eclipse.comma.monitoring.lib.utils.Utils;

public abstract class CRule
implements Serializable {
    protected String name;
    protected CObservedMessage triggeringObservation;
    protected CObservedMessage lastObservation;
    protected String errorMessage;
    protected boolean activated = false;
    protected CFormula formula;
    protected List<CRuleObserver> ruleObservers = new ArrayList<CRuleObserver>();
    protected CRuleError error = null;

    public CRule setName(String n) {
        this.name = n;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public CObservedMessage getTriggeringObservation() {
        return this.triggeringObservation;
    }

    public CObservedMessage getLastObservation() {
        return this.lastObservation;
    }

    public CRule setErrorMessage(String m) {
        this.errorMessage = m;
        return this;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public CRule setFormula(CFormula f) {
        this.formula = f;
        return this;
    }

    public CFormula getFormula() {
        return this.formula;
    }

    public void registerObserver(CRuleObserver observer) {
        this.ruleObservers.add(observer);
    }

    public void unregisterObserver(CRuleObserver observer) {
        this.ruleObservers.remove(observer);
    }

    public void clearObservers() {
        this.ruleObservers.clear();
    }

    public void notifyOnSuccess() {
        for (CRuleObserver observer : this.ruleObservers) {
            observer.ruleSucceeded(this);
        }
    }

    public void notifyOnFailure() {
        for (CRuleObserver observer : this.ruleObservers) {
            observer.ruleFailed(this);
        }
    }

    public CRuleError getError() {
        return this.error;
    }

    public void produceError(CObservedMessage failingObservation) {
        this.error = new CRuleError(this.name, this.errorMessage, this.triggeringObservation, failingObservation);
    }

    public CConstraintValue consume(CObservedMessage message) {
        this.lastObservation = message;
        CConstraintValue r = this.formula.consume(message);
        if (!this.activated && r != CConstraintValue.TRUE) {
            this.activated = true;
            this.triggeringObservation = message;
        }
        if (r == CConstraintValue.FALSE) {
            this.produceError(message);
            this.notifyOnFailure();
        }
        return r;
    }

    public CRule deepCopy() {
        CRule result = (CRule)Utils.deepCopy(this);
        result.clearObservers();
        for (CRuleObserver observer : this.ruleObservers) {
            result.registerObserver(observer);
        }
        return result;
    }
}

