/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.java;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum JVisibility implements Enumerator
{
    PUBLIC_LITERAL(0, "public", "public"),
    PROTECTED_LITERAL(1, "protected", "protected"),
    PRIVATE_LITERAL(2, "private", "private"),
    PACKAGE_LITERAL(3, "package", "package");

    public static final int PUBLIC = 0;
    public static final int PROTECTED = 1;
    public static final int PRIVATE = 2;
    public static final int PACKAGE = 3;
    private static final JVisibility[] VALUES_ARRAY;
    public static final List<JVisibility> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new JVisibility[]{PUBLIC_LITERAL, PROTECTED_LITERAL, PRIVATE_LITERAL, PACKAGE_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static JVisibility get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            JVisibility result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static JVisibility getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            JVisibility result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static JVisibility get(int value) {
        switch (value) {
            case 0: {
                return PUBLIC_LITERAL;
            }
            case 1: {
                return PROTECTED_LITERAL;
            }
            case 2: {
                return PRIVATE_LITERAL;
            }
            case 3: {
                return PACKAGE_LITERAL;
            }
        }
        return null;
    }

    private JVisibility(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

