/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d;

import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.draw3d.graphics3d.Graphics3D;
import org.eclipse.draw3d.util.Draw3DCache;

public class GLd3d {
    private static final Pattern VERSION_PATTERN = Pattern.compile("(\\d+)\\.(\\d+).*");

    public static int getAlignedWidth(Graphics3D g3d, int i_width) {
        int alignedWidth = i_width;
        int unpackAlignment = GLd3d.glGetInteger(g3d, 3317);
        int rest = alignedWidth % unpackAlignment;
        if (rest > 0) {
            alignedWidth += unpackAlignment - rest;
        }
        return alignedWidth;
    }

    public static int[] getVersion(Graphics3D g3d) {
        String versionString = g3d.glGetString(7938);
        Matcher matcher = VERSION_PATTERN.matcher(versionString);
        if (!matcher.matches()) {
            throw new IllegalStateException("invalid OpenGL version string: " + versionString);
        }
        int majorVersion = Integer.parseInt(matcher.group(1));
        int minorVersion = Integer.parseInt(matcher.group(2));
        return new int[]{majorVersion, minorVersion};
    }

    public static float glGetFloat(Graphics3D g3d, int pname) {
        float f;
        FloatBuffer buffer = Draw3DCache.getFloatBuffer(16);
        try {
            buffer.rewind();
            g3d.glGetFloat(pname, buffer);
            f = buffer.get(0);
        }
        catch (Throwable throwable) {
            Draw3DCache.returnFloatBuffer(buffer);
            throw throwable;
        }
        Draw3DCache.returnFloatBuffer(buffer);
        return f;
    }

    public static int glGetInteger(Graphics3D g3d, int pname) {
        int n;
        IntBuffer buffer = Draw3DCache.getIntBuffer(16);
        try {
            buffer.rewind();
            g3d.glGetInteger(pname, buffer);
            n = buffer.get(0);
        }
        catch (Throwable throwable) {
            Draw3DCache.returnIntBuffer(buffer);
            throw throwable;
        }
        Draw3DCache.returnIntBuffer(buffer);
        return n;
    }
}

